/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation;

import io.micronaut.core.annotation.Internal;
import io.micronaut.validation.InternalUriMatchVariable;
import io.micronaut.validation.InternalUriTemplate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Deprecated
@Internal
public final class InternalUriMatchTemplate
extends InternalUriTemplate {
    protected static final String VARIABLE_MATCH_PATTERN = "([^\\/\\?#&;\\+]";
    protected StringBuilder pattern;
    protected List<InternalUriMatchVariable> variables;

    public InternalUriMatchTemplate(CharSequence templateString) {
        this(templateString, new Object[0]);
    }

    protected InternalUriMatchTemplate(CharSequence templateString, Object ... parserArguments) {
        super(templateString, parserArguments);
    }

    public List<String> getVariableNames() {
        return this.variables.stream().map(InternalUriMatchVariable::getName).collect(Collectors.toList());
    }

    public List<InternalUriMatchVariable> getVariables() {
        return this.variables;
    }

    public static InternalUriMatchTemplate of(String uri) {
        return new InternalUriMatchTemplate(uri);
    }

    @Override
    protected InternalUriTemplate.UriTemplateParser createParser(String templateString, Object ... parserArguments) {
        if (Objects.isNull(this.pattern)) {
            this.pattern = new StringBuilder();
        }
        if (this.variables == null) {
            this.variables = new ArrayList<InternalUriMatchVariable>();
        }
        return new UriMatchTemplateParser(templateString, this);
    }

    protected static class UriMatchTemplateParser
    extends InternalUriTemplate.UriTemplateParser {
        final InternalUriMatchTemplate matchTemplate;

        protected UriMatchTemplateParser(String templateText, InternalUriMatchTemplate matchTemplate) {
            super(templateText);
            this.matchTemplate = matchTemplate;
        }

        public InternalUriMatchTemplate getMatchTemplate() {
            return this.matchTemplate;
        }

        @Override
        protected void addRawContentSegment(List<InternalUriTemplate.PathSegment> segments, String value, boolean isQuerySegment) {
            this.matchTemplate.pattern.append(Pattern.quote(value));
            super.addRawContentSegment(segments, value, isQuerySegment);
        }

        @Override
        protected void addVariableSegment(List<InternalUriTemplate.PathSegment> segments, String variable, String prefix, String delimiter, boolean encode, boolean repeatPrefix, String modifierStr, char modifierChar, char operator, String previousDelimiter, boolean isQuerySegment) {
            this.matchTemplate.variables.add(new InternalUriMatchVariable(variable, modifierChar, operator));
            StringBuilder pattern = this.matchTemplate.pattern;
            int modLen = modifierStr.length();
            boolean hasModifier = modifierChar == ':' && modLen > 0;
            String operatorPrefix = "";
            String operatorQuantifier = "";
            String variableQuantifier = "+?)";
            String variablePattern = this.getVariablePattern(variable, operator);
            if (hasModifier) {
                char firstChar = modifierStr.charAt(0);
                if (firstChar == '?') {
                    operatorQuantifier = "";
                } else if (modifierStr.chars().allMatch(Character::isDigit)) {
                    variableQuantifier = "{1," + modifierStr + "})";
                } else {
                    char lastChar = modifierStr.charAt(modLen - 1);
                    if (lastChar == '*' || modLen > 1 && lastChar == '?' && (modifierStr.charAt(modLen - 2) == '*' || modifierStr.charAt(modLen - 2) == '+')) {
                        operatorQuantifier = "?";
                    }
                    if (operator == '/' || operator == '.') {
                        variablePattern = "(" + (firstChar == '^' ? modifierStr.substring(1) : modifierStr) + ")";
                    } else {
                        operatorPrefix = "(";
                        variablePattern = (firstChar == '^' ? modifierStr.substring(1) : modifierStr) + ")";
                    }
                    variableQuantifier = "";
                }
            }
            boolean operatorAppended = false;
            switch (operator) {
                case '.': 
                case '/': {
                    pattern.append("(").append(operatorPrefix).append("\\").append(String.valueOf(operator)).append(operatorQuantifier);
                    operatorAppended = true;
                }
                case '+': 
                case '0': {
                    if (!operatorAppended) {
                        pattern.append("(").append(operatorPrefix);
                    }
                    pattern.append(variablePattern).append(variableQuantifier).append(")");
                    break;
                }
            }
            if (operator == '/' || modifierStr.equals("?")) {
                pattern.append("?");
            }
            super.addVariableSegment(segments, variable, prefix, delimiter, encode, repeatPrefix, modifierStr, modifierChar, operator, previousDelimiter, isQuerySegment);
        }

        protected String getVariablePattern(String variable, char operator) {
            if (operator == '+') {
                return "([\\S]";
            }
            return InternalUriMatchTemplate.VARIABLE_MATCH_PATTERN;
        }
    }
}

