/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator.constraints;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.validation.validator.constraints.ConstraintValidator;
import io.micronaut.validation.validator.constraints.ConstraintValidatorContext;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.Size;

@FunctionalInterface
public interface SizeValidator<T>
extends ConstraintValidator<Size, T> {
    @Override
    default public boolean isValid(@Nullable T value, @Nonnull AnnotationValue<Size> annotationMetadata, @Nonnull ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        int len = this.getSize(value);
        int max = annotationMetadata.get((CharSequence)"max", Integer.class).orElse(Integer.MAX_VALUE);
        int min = annotationMetadata.get((CharSequence)"min", Integer.class).orElse(0);
        return len <= max && len >= min;
    }

    public int getSize(@Nonnull T var1);
}

