/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation;

import io.micronaut.aop.InterceptPhase;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.validation.validator.ExecutableMethodValidator;
import io.micronaut.validation.validator.ReactiveValidator;
import io.micronaut.validation.validator.Validator;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.validation.Constraint;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Valid;
import javax.validation.ValidatorFactory;
import javax.validation.executable.ExecutableValidator;
import org.reactivestreams.Publisher;

@Singleton
public class ValidatingInterceptor
implements MethodInterceptor {
    public static final int POSITION = InterceptPhase.VALIDATE.getPosition();
    @Nullable
    private final ExecutableValidator executableValidator;
    @Nullable
    private final ExecutableMethodValidator micronautValidator;

    @Deprecated
    public ValidatingInterceptor(Optional<ValidatorFactory> validatorFactory) {
        this(Validator.getInstance(), validatorFactory.orElse(null));
    }

    @Inject
    public ValidatingInterceptor(@Nullable Validator micronautValidator, @Nullable ValidatorFactory validatorFactory) {
        if (validatorFactory != null) {
            javax.validation.Validator validator = validatorFactory.getValidator();
            if (validator instanceof Validator) {
                this.micronautValidator = (ExecutableMethodValidator)validator;
                this.executableValidator = null;
            } else {
                this.micronautValidator = null;
                this.executableValidator = validator.forExecutables();
            }
        } else if (micronautValidator != null) {
            this.micronautValidator = micronautValidator.forExecutables();
            this.executableValidator = null;
        } else {
            this.micronautValidator = null;
            this.executableValidator = null;
        }
    }

    public int getOrder() {
        return POSITION;
    }

    public Object intercept(MethodInvocationContext context) {
        boolean isValidatorBeanNull;
        boolean bl = isValidatorBeanNull = this.executableValidator == null;
        if (isValidatorBeanNull && this.micronautValidator == null) {
            return context.proceed();
        }
        Object target = context.getTarget();
        if (isValidatorBeanNull) {
            ExecutableMethod executableMethod = context.getExecutableMethod();
            Set<ConstraintViolation<Object>> constraintViolations = this.micronautValidator.validateParameters(target, executableMethod, context.getParameters().values(), new Class[0]);
            boolean supportsReactive = this.micronautValidator instanceof ReactiveValidator;
            if (constraintViolations.isEmpty()) {
                Object result = context.proceed();
                if (context.hasStereotype(Valid.class) || context.hasStereotype(Constraint.class)) {
                    boolean hasResult;
                    boolean bl2 = hasResult = result != null;
                    if (supportsReactive & hasResult && Publishers.isConvertibleToPublisher((Object)result)) {
                        ReactiveValidator reactiveValidator = (ReactiveValidator)((Object)this.micronautValidator);
                        Publisher newPublisher = reactiveValidator.validatePublisher((Publisher)Publishers.convertPublisher((Object)result, Publisher.class), new Class[0]);
                        return Publishers.convertPublisher(newPublisher, (Class)executableMethod.getReturnType().getType());
                    }
                    if (supportsReactive & result instanceof CompletionStage) {
                        return ((ReactiveValidator)((Object)this.micronautValidator)).validateCompletionStage((CompletionStage)result, new Class[0]);
                    }
                    constraintViolations = this.micronautValidator.validateReturnValue(target, executableMethod, result, new Class[0]);
                    if (!constraintViolations.isEmpty()) {
                        throw new ConstraintViolationException(constraintViolations);
                    }
                }
                return result;
            }
            throw new ConstraintViolationException(constraintViolations);
        }
        Method targetMethod = context.getTargetMethod();
        if (targetMethod.getParameterTypes().length == 0) {
            Object result = context.proceed();
            return this.validateReturnValue(this.executableValidator, context, target, targetMethod, result);
        }
        Set constraintViolations = this.executableValidator.validateParameters(target, targetMethod, context.getParameterValues(), new Class[0]);
        if (constraintViolations.isEmpty()) {
            Object result = context.proceed();
            return this.validateReturnValue(this.executableValidator, context, target, targetMethod, result);
        }
        throw new ConstraintViolationException(constraintViolations);
    }

    private Object validateReturnValue(@Nonnull ExecutableValidator validator, MethodInvocationContext context, Object target, Method targetMethod, Object result) {
        Set constraintViolations;
        if (context.hasStereotype(Valid.class) && !(constraintViolations = validator.validateReturnValue(target, targetMethod, result, new Class[0])).isEmpty()) {
            throw new ConstraintViolationException(constraintViolations);
        }
        return result;
    }
}

