/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.routes;

import io.micronaut.context.env.DefaultPropertyPlaceholderResolver;
import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.http.annotation.HttpMethodMapping;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.validation.routes.RouteParameterElement;
import io.micronaut.validation.routes.RouteValidationResult;
import io.micronaut.validation.routes.rules.MissingParameterRule;
import io.micronaut.validation.routes.rules.NullableParameterRule;
import io.micronaut.validation.routes.rules.RouteValidationRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RouteValidationVisitor
implements TypeElementVisitor<Object, HttpMethodMapping> {
    private List<RouteValidationRule> rules = new ArrayList<RouteValidationRule>();
    private boolean skipValidation = false;
    private final PropertyPlaceholderResolver resolver = new DefaultPropertyPlaceholderResolver(null){

        protected boolean resolveReplacement(StringBuilder builder, String str, String expr) {
            builder.append("tmp");
            return true;
        }
    };

    public void visitMethod(MethodElement element, VisitorContext context) {
        if (this.skipValidation) {
            return;
        }
        AnnotationValue mappingAnnotation = element.getAnnotation(HttpMethodMapping.class);
        if (mappingAnnotation != null) {
            String uri = (String)mappingAnnotation.getRequiredValue(String.class);
            UriMatchTemplate template = UriMatchTemplate.of((String)this.resolver.resolveRequiredPlaceholders(uri));
            ParameterElement[] parameters = (RouteParameterElement[])Arrays.stream(element.getParameters()).map(RouteParameterElement::new).toArray(RouteParameterElement[]::new);
            for (RouteValidationRule rule : this.rules) {
                RouteValidationResult result = rule.validate(template, parameters);
                if (result.isValid()) continue;
                for (String err : result.getErrorMessages()) {
                    context.fail(err, (Element)element);
                }
            }
        }
    }

    public void start(VisitorContext visitorContext) {
        String prop = System.getProperty("micronaut.route.validation");
        this.skipValidation = prop != null && prop.equals("false");
        this.rules.add(new MissingParameterRule());
        this.rules.add(new NullableParameterRule());
    }
}

