/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.routes.rules;

import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.http.uri.UriMatchVariable;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.validation.routes.RouteValidationResult;
import io.micronaut.validation.routes.rules.RouteValidationRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

public class NullableParameterRule
implements RouteValidationRule {
    @Override
    public RouteValidationResult validate(UriMatchTemplate template, ParameterElement[] parameters) {
        List variables = template.getVariables();
        ArrayList errorMessages = new ArrayList();
        for (UriMatchVariable variable : variables) {
            if (!variable.isOptional() || variable.isExploded()) continue;
            Arrays.stream(parameters).filter(p -> p.getName().equals(variable.getName())).findFirst().ifPresent(p -> {
                ClassElement type = p.getType();
                if (!p.hasAnnotation(Nullable.class) && type != null && !type.isAssignable(Optional.class)) {
                    errorMessages.add(String.format("The uri variable [%s] is optional, but the corresponding method argument [%s] is not defined as an Optional or annotated with the javax.annotation.Nullable annotation.", variable.getName(), p.toString()));
                }
            });
        }
        return new RouteValidationResult(errorMessages.toArray(new String[0]));
    }
}

