/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.exceptions;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.hateos.JsonError;
import io.micronaut.http.hateos.Link;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.inject.Singleton;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Path;

@Produces
@Singleton
@Requires(classes={ConstraintViolationException.class, ExceptionHandler.class})
public class ConstraintExceptionHandler
implements ExceptionHandler<ConstraintViolationException, HttpResponse<JsonError>> {
    public HttpResponse<JsonError> handle(HttpRequest request, ConstraintViolationException exception) {
        Set constraintViolations = exception.getConstraintViolations();
        if (constraintViolations.size() == 1) {
            ConstraintViolation violation = (ConstraintViolation)constraintViolations.iterator().next();
            StringBuilder message = new StringBuilder();
            Path propertyPath = violation.getPropertyPath();
            boolean first = true;
            Iterator i = propertyPath.iterator();
            while (i.hasNext()) {
                Path.Node node = (Path.Node)i.next();
                if (first) {
                    first = false;
                    continue;
                }
                message.append(node);
                if (!i.hasNext()) continue;
                message.append('.');
            }
            message.append(": ").append(violation.getMessage());
            JsonError error = new JsonError(message.toString());
            error.link(Link.SELF, Link.of((URI)request.getUri()));
            return HttpResponse.badRequest((Object)error);
        }
        JsonError error = new JsonError(HttpStatus.BAD_REQUEST.getReason());
        ArrayList<JsonError> errors = new ArrayList<JsonError>();
        for (ConstraintViolation violation : constraintViolations) {
            StringBuilder message = new StringBuilder();
            Path propertyPath = violation.getPropertyPath();
            boolean first = true;
            for (Path.Node node : propertyPath) {
                if (first) {
                    first = false;
                    continue;
                }
                message.append(node).append('.');
            }
            message.append(':').append(violation.getMessage());
            errors.add(new JsonError(message.toString()));
        }
        error.embedded((CharSequence)"_embedded", errors);
        error.link(Link.SELF, Link.of((URI)request.getUri()));
        return HttpResponse.badRequest((Object)error);
    }
}

