/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.session.http;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.server.util.locale.HttpAbstractLocaleResolver;
import io.micronaut.http.server.util.locale.HttpLocaleResolutionConfiguration;
import io.micronaut.session.http.SessionForRequest;
import java.util.Locale;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
@Requires(property="micronaut.server.locale-resolution.session-attribute")
public class SessionLocaleResolver
extends HttpAbstractLocaleResolver {
    private final String sessionAttribute;

    public SessionLocaleResolver(HttpLocaleResolutionConfiguration httpLocaleResolutionConfiguration) {
        super(httpLocaleResolutionConfiguration);
        this.sessionAttribute = (String)httpLocaleResolutionConfiguration.getSessionAttribute().orElseThrow(() -> new IllegalArgumentException("The session attribute must be set"));
    }

    @NonNull
    public Optional<Locale> resolve(@NonNull HttpRequest<?> request) {
        return SessionForRequest.find(request).flatMap(session -> session.get(this.sessionAttribute, Locale.class));
    }
}

