/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.session;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.session.Session;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class InMemorySession
implements Session {
    protected final Map<CharSequence, Object> attributeMap = new LinkedHashMap<CharSequence, Object>();
    protected final MutableConvertibleValues<Object> attributes = MutableConvertibleValues.of(this.attributeMap);
    protected Instant lastAccessTime = Instant.now();
    private final String id;
    private final Instant creationTime;
    private Duration maxInactiveInterval;
    private boolean isNew = true;

    protected InMemorySession(String id, Duration maxInactiveInterval) {
        this(id, Instant.now(), maxInactiveInterval);
    }

    protected InMemorySession(String id, Instant creationTime, Duration maxInactiveInterval) {
        this.id = id;
        this.creationTime = creationTime;
        this.maxInactiveInterval = maxInactiveInterval;
    }

    @Override
    @NonNull
    public String getId() {
        return this.id;
    }

    @Override
    @NonNull
    public Instant getLastAccessedTime() {
        return this.lastAccessTime;
    }

    @Override
    public Session setMaxInactiveInterval(Duration duration) {
        if (duration != null) {
            this.maxInactiveInterval = duration;
        }
        return this;
    }

    @Override
    public Session setLastAccessedTime(Instant instant) {
        if (instant != null) {
            this.lastAccessTime = instant;
        }
        return this;
    }

    @Override
    public Duration getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public boolean isModified() {
        return this.isNew;
    }

    @Override
    @NonNull
    public Instant getCreationTime() {
        return this.creationTime;
    }

    public MutableConvertibleValues<Object> put(CharSequence key, Object value) {
        return this.attributes.put(key, value);
    }

    public MutableConvertibleValues<Object> remove(CharSequence key) {
        return this.attributes.remove(key);
    }

    public MutableConvertibleValues<Object> clear() {
        return this.attributes.clear();
    }

    public Set<String> names() {
        return this.attributes.names();
    }

    public Collection<Object> values() {
        return this.attributes.values();
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        return this.attributes.get(name, conversionContext);
    }

    public void setNew(boolean aNew) {
        this.isNew = aNew;
    }
}

