/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.session.binder;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.TypedRequestArgumentBinder;
import io.micronaut.http.filter.OncePerRequestHttpServerFilter;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.session.Session;
import io.micronaut.session.SessionStore;
import io.micronaut.session.http.HttpSessionFilter;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
@Requires(classes={HttpServerConfiguration.class})
public class SessionArgumentBinder
implements TypedRequestArgumentBinder<Session> {
    private final SessionStore<Session> sessionStore;

    public SessionArgumentBinder(SessionStore<Session> sessionStore) {
        this.sessionStore = sessionStore;
    }

    public Argument<Session> argumentType() {
        return Argument.of(Session.class);
    }

    public ArgumentBinder.BindingResult<Session> bind(ArgumentConversionContext<Session> context, HttpRequest<?> source) {
        if (!source.getAttributes().contains(OncePerRequestHttpServerFilter.getKey(HttpSessionFilter.class))) {
            return ArgumentBinder.BindingResult.EMPTY;
        }
        MutableConvertibleValues attrs = source.getAttributes();
        Optional existing = attrs.get(HttpSessionFilter.SESSION_ATTRIBUTE, Session.class);
        if (existing.isPresent()) {
            return () -> existing;
        }
        if (!context.getArgument().isNullable()) {
            Session newSession = this.sessionStore.newSession();
            attrs.put(HttpSessionFilter.SESSION_ATTRIBUTE, (Object)newSession);
            return () -> Optional.of(newSession);
        }
        return ArgumentBinder.BindingResult.EMPTY;
    }
}

