/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery;

import io.micronaut.core.naming.Described;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.discovery.DiscoveryClient;
import io.micronaut.discovery.ServiceInstance;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public abstract class CompositeDiscoveryClient
implements DiscoveryClient {
    private final DiscoveryClient[] discoveryClients;

    protected CompositeDiscoveryClient(DiscoveryClient[] discoveryClients) {
        this.discoveryClients = discoveryClients;
    }

    public String getDescription() {
        return this.toString();
    }

    public DiscoveryClient[] getDiscoveryClients() {
        return this.discoveryClients;
    }

    public Flowable<List<ServiceInstance>> getInstances(String serviceId) {
        serviceId = NameUtils.hyphenate((String)serviceId);
        if (ArrayUtils.isEmpty((Object[])this.discoveryClients)) {
            return Flowable.just(Collections.emptyList());
        }
        String finalServiceId = serviceId;
        Single reduced = Flowable.fromArray((Object[])this.discoveryClients).flatMap(client -> client.getInstances(finalServiceId)).reduce(new ArrayList(), (instances, otherInstances) -> {
            instances.addAll(otherInstances);
            return instances;
        });
        return reduced.toFlowable();
    }

    public Flowable<List<String>> getServiceIds() {
        if (ArrayUtils.isEmpty((Object[])this.discoveryClients)) {
            return Flowable.just(Collections.emptyList());
        }
        Single reduced = Flowable.fromArray((Object[])this.discoveryClients).flatMap(DiscoveryClient::getServiceIds).reduce(new ArrayList(), (serviceIds, otherServiceIds) -> {
            serviceIds.addAll(otherServiceIds);
            return serviceIds;
        });
        return reduced.toFlowable();
    }

    @Override
    public void close() throws IOException {
        for (DiscoveryClient discoveryClient : this.discoveryClients) {
            discoveryClient.close();
        }
    }

    public String toString() {
        return "compositeDiscoveryClient(" + Arrays.stream(this.discoveryClients).map(Described::getDescription).collect(Collectors.joining(",")) + ")";
    }
}

