/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.test.support;

import io.micronaut.annotation.processing.test.support.UtilsKt;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0000\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0000\u00a8\u0006\u000b"}, d2={"findToolsJarFromJdk", "Ljava/io/File;", "jdkHome", "getJavacVersionString", "", "javacCommand", "isJavac9OrLater", "", "javacVersionString", "parseVersionString", "output", "micronaut-inject-kotlin-test"})
@SourceDebugExtension(value={"SMAP\nJavacUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavacUtils.kt\nio/micronaut/annotation/processing/test/support/JavacUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1#2:129\n*E\n"})
public final class JavacUtilsKt {
    @NotNull
    public static final String getJavacVersionString(@NotNull String javacCommand) {
        Intrinsics.checkNotNullParameter((Object)javacCommand, (String)"javacCommand");
        Object[] objectArray = new String[]{javacCommand, "-version"};
        Process javacProc = new ProcessBuilder(CollectionsKt.listOf((Object[])objectArray)).redirectErrorStream(true).start();
        Buffer buffer = new Buffer();
        InputStream inputStream = javacProc.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)buffer.outputStream(), (int)0, (int)2, null);
        javacProc.waitFor();
        String output = buffer.readUtf8();
        String string = JavacUtilsKt.parseVersionString(output);
        if (string == null) {
            throw new IllegalStateException("Command '" + javacCommand + " -version' did not print expected output. Output was: '" + output + "'");
        }
        return string;
    }

    @Nullable
    public static final String parseVersionString(@NotNull String output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        MatchResult matchResult = Regex.find$default((Regex)new Regex("javac (.*)?[\\s\\S]*"), (CharSequence)output, (int)0, (int)2, null);
        return matchResult != null && (matchResult = matchResult.getDestructured()) != null ? (String)matchResult.getMatch().getGroupValues().get(1) : null;
    }

    public static final boolean isJavac9OrLater(@NotNull String javacVersionString) {
        Intrinsics.checkNotNullParameter((Object)javacVersionString, (String)"javacVersionString");
        try {
            MatchResult matchResult = new Regex("([0-9]*)(?:\\.([0-9]*))?(?:\\.([0-9]*))?(.*)").matchEntire((CharSequence)javacVersionString);
            if (matchResult == null || (matchResult = matchResult.getDestructured()) == null) {
                throw new IllegalArgumentException("Could not match version regex");
            }
            MatchResult matchResult2 = matchResult;
            String majorv = (String)matchResult2.getMatch().getGroupValues().get(1);
            String minorv = (String)matchResult2.getMatch().getGroupValues().get(2);
            String patchv = (String)matchResult2.getMatch().getGroupValues().get(3);
            String otherv = (String)matchResult2.getMatch().getGroupValues().get(4);
            if (!(!StringsKt.isBlank((CharSequence)majorv))) {
                boolean $i$a$-check-JavacUtilsKt$isJavac9OrLater$32 = false;
                String $i$a$-check-JavacUtilsKt$isJavac9OrLater$32 = "Major version can not be blank";
                throw new IllegalStateException($i$a$-check-JavacUtilsKt$isJavac9OrLater$32.toString());
            }
            if (Integer.parseInt(majorv) == 1 && !(!StringsKt.isBlank((CharSequence)minorv))) {
                boolean bl = false;
                String string = "Minor version can not be blank if major version is 1";
                throw new IllegalStateException(string.toString());
            }
            return Integer.parseInt(majorv) == 1 && Integer.parseInt(minorv) >= 9 || Integer.parseInt(majorv) >= 9;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Could not parse javac version string: '" + javacVersionString + "'", t);
        }
    }

    @NotNull
    public static final File findToolsJarFromJdk(@NotNull File jdkHome2) {
        Intrinsics.checkNotNullParameter((Object)jdkHome2, (String)"jdkHome");
        File file = UtilsKt.existsOrNull(FilesKt.resolve((File)jdkHome2, (String)"../lib/tools.jar"));
        if (file == null && (file = UtilsKt.existsOrNull(FilesKt.resolve((File)jdkHome2, (String)"lib/tools.jar"))) == null && (file = UtilsKt.existsOrNull(FilesKt.resolve((File)jdkHome2, (String)"tools.jar"))) == null) {
            throw new IllegalStateException("Can not find tools.jar from JDK with path " + jdkHome2.getAbsolutePath());
        }
        return file;
    }
}

