/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.javadoc.Javadoc;
import com.github.javaparser.javadoc.JavadocBlockTag;
import io.micronaut.annotation.processing.visitor.AbstractJavaElement;
import io.micronaut.annotation.processing.visitor.AbstractTypeAwareJavaElement;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaMethodElement;
import io.micronaut.annotation.processing.visitor.JavaNativeElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Internal
final class JavaParameterElement
extends AbstractTypeAwareJavaElement
implements ParameterElement,
TypedElement {
    private final JavaClassElement owningType;
    private final JavaMethodElement methodElement;
    private ClassElement typeElement;
    private ClassElement genericTypeElement;

    JavaParameterElement(JavaClassElement owningType, JavaMethodElement methodElement, JavaNativeElement.Variable nativeElement, ElementAnnotationMetadataFactory annotationMetadataFactory, JavaVisitorContext visitorContext) {
        super(nativeElement, annotationMetadataFactory, visitorContext);
        this.owningType = owningType;
        this.methodElement = methodElement;
    }

    @Override
    public @NonNull JavaNativeElement.Variable getNativeType() {
        return (JavaNativeElement.Variable)super.getNativeType();
    }

    @Override
    protected AbstractJavaElement copyThis() {
        return new JavaParameterElement(this.owningType, this.methodElement, this.getNativeType(), this.elementAnnotationMetadataFactory, this.visitorContext);
    }

    public ParameterElement withAnnotationMetadata(AnnotationMetadata annotationMetadata) {
        return (ParameterElement)super.withAnnotationMetadata(annotationMetadata);
    }

    @Override
    protected boolean hasNullMarked() {
        return this.methodElement.hasNullMarked();
    }

    public boolean isPrimitive() {
        return this.getType().isPrimitive();
    }

    public boolean isArray() {
        return this.getType().isArray();
    }

    public int getArrayDimensions() {
        return this.getType().getArrayDimensions();
    }

    public @NonNull ClassElement getType() {
        if (this.typeElement == null) {
            this.typeElement = this.newClassElement(this.getNativeType(), this.getNativeType().element().asType(), Collections.emptyMap());
        }
        return this.typeElement;
    }

    public @NonNull ClassElement getGenericType() {
        if (this.genericTypeElement == null) {
            this.genericTypeElement = this.newClassElement(this.getNativeType(), this.getNativeType().element().asType(), this.methodElement.getTypeArguments());
        }
        return this.genericTypeElement;
    }

    public MethodElement getMethodElement() {
        return this.methodElement;
    }

    @Override
    protected AnnotationMetadata getTypeAnnotationMetadata() {
        return this.getType().getTypeAnnotationMetadata();
    }

    @Override
    public Optional<String> getDocumentation(boolean parse) {
        if (!parse) {
            return Optional.empty();
        }
        try {
            JavaMethodElement javaMethodElement;
            String parameterDoc;
            String methodDocComment = this.visitorContext.getElements().getDocComment(this.methodElement.getNativeType().element());
            if (methodDocComment != null && (parameterDoc = JavaParameterElement.findParameterDoc(methodDocComment, this.getName())) != null) {
                return Optional.of(parameterDoc);
            }
            if (this.owningType.isRecord() && (javaMethodElement = this.methodElement) instanceof ConstructorElement) {
                String docComment;
                ConstructorElement constructor = (ConstructorElement)javaMethodElement;
                List beanProperties = constructor.getDeclaringType().getBeanProperties();
                ParameterElement[] parameters = constructor.getParameters();
                if (beanProperties.size() == parameters.length && (docComment = this.visitorContext.getElements().getDocComment(this.owningType.getNativeType().element())) != null) {
                    return Optional.ofNullable(JavaParameterElement.findParameterDoc(docComment, this.getName()));
                }
            }
            return Optional.empty();
        }
        catch (Exception ignore) {
            return Optional.empty();
        }
    }

    private static @Nullable String findParameterDoc(String javadocString, String name) {
        try {
            Javadoc javadoc = StaticJavaParser.parseJavadoc((String)javadocString);
            if (javadoc == null) {
                return null;
            }
            for (JavadocBlockTag t : javadoc.getBlockTags()) {
                if (t.getType() != JavadocBlockTag.Type.PARAM || !t.getName().map(n -> n.equals(name)).orElse(false).booleanValue()) continue;
                return t.getContent().toText();
            }
            return null;
        }
        catch (Exception ignored) {
            return null;
        }
    }
}

