/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.utils.NativeElementsHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.jspecify.annotations.NonNull;

@Internal
public final class JavaNativeElementsHelper
extends NativeElementsHelper<TypeElement, ExecutableElement> {
    private final Elements elementUtils;
    private final Types typeUtils;

    public JavaNativeElementsHelper(Elements elementUtils, Types typeUtils) {
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
    }

    public Collection<ExecutableElement> findOverriddenMethods(ExecutableElement methodElement) {
        return this.findOverriddenMethods((TypeElement)methodElement.getEnclosingElement(), methodElement);
    }

    protected boolean overrides(ExecutableElement m1, ExecutableElement m2, TypeElement typeElement) {
        return this.elementUtils.overrides(m1, m2, typeElement);
    }

    protected @NonNull String getMethodName(ExecutableElement element) {
        return element.getSimpleName().toString();
    }

    protected TypeElement getSuperClass(TypeElement classNode) {
        TypeMirror superclass = classNode.getSuperclass();
        if (superclass.getKind() == TypeKind.NONE) {
            return null;
        }
        DeclaredType kind = (DeclaredType)superclass;
        return (TypeElement)kind.asElement();
    }

    protected @NonNull Collection<TypeElement> getInterfaces(TypeElement classNode) {
        List<? extends TypeMirror> interfacesMirrors = classNode.getInterfaces();
        ArrayList<TypeElement> interfaces = new ArrayList<TypeElement>(interfacesMirrors.size());
        for (TypeMirror typeMirror : interfacesMirrors) {
            Element e = this.typeUtils.asElement(typeMirror);
            if (!(e instanceof TypeElement)) continue;
            TypeElement te = (TypeElement)e;
            interfaces.add(te);
        }
        return interfaces;
    }

    protected @NonNull List<ExecutableElement> getMethods(TypeElement classNode) {
        return ElementFilter.methodsIn(classNode.getEnclosedElements());
    }

    protected boolean excludeClass(TypeElement classNode) {
        return classNode.getQualifiedName().toString().equals(Object.class.getName()) || classNode.getQualifiedName().toString().equals(Enum.class.getName());
    }

    protected boolean isInterface(TypeElement classNode) {
        return classNode.getKind() == ElementKind.INTERFACE;
    }
}

