/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.annotation.processing.AbstractInjectAnnotationProcessor;
import io.micronaut.annotation.processing.AggregatingPackageElementVisitorProcessor;
import io.micronaut.annotation.processing.JavaElementAnnotationMetadataFactory;
import io.micronaut.annotation.processing.PackageLoadedVisitor;
import io.micronaut.annotation.processing.visitor.JavaPackageElement;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.util.Toggleable;
import io.micronaut.inject.ast.PackageElement;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import io.micronaut.inject.visitor.PackageElementVisitor;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.jspecify.annotations.NonNull;

@SupportedOptions(value={"micronaut.processing.incremental", "micronaut.processing.annotations", "micronaut.processing.project.dir", "micronaut.processing.group", "micronaut.processing.module"})
public sealed class PackageElementVisitorProcessor
extends AbstractInjectAnnotationProcessor
permits AggregatingPackageElementVisitorProcessor {
    private static final Set<String> SUPPORTED_ANNOTATION_NAMES;
    private List<PackageLoadedVisitor> packageVisitors;

    static Set<String> getVisitedAnnotationNames() {
        return SUPPORTED_ANNOTATION_NAMES;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        Collection<PackageElementVisitor<?>> packageElementVisitors = PackageElementVisitorProcessor.findPackageElementVisitors();
        processingEnv.getOptions().entrySet().stream().filter(entry -> entry.getKey() != null && ((String)entry.getKey()).startsWith("micronaut")).forEach(entry -> System.setProperty((String)entry.getKey(), entry.getValue() == null ? "" : (String)entry.getValue()));
        this.packageVisitors = new ArrayList<PackageLoadedVisitor>(packageElementVisitors.size());
        TypeElementVisitor.VisitorKind incrementalProcessorKind = this.getIncrementalProcessorKind();
        for (PackageElementVisitor<?> visitor : packageElementVisitors) {
            TypeElementVisitor.VisitorKind visitorKind = visitor.getVisitorKind();
            if (incrementalProcessorKind != visitorKind) continue;
            try {
                this.packageVisitors.add(PackageLoadedVisitor.of(visitor, processingEnv));
            }
            catch (NoClassDefFoundError | TypeNotPresentException throwable) {}
        }
        OrderUtil.reverseSort(this.packageVisitors);
    }

    protected boolean hasVisitors() {
        for (PackageElementVisitor<?> packageElementVisitor : PackageElementVisitorProcessor.findPackageElementVisitors()) {
            if (packageElementVisitor.getVisitorKind() != this.getVisitorKind()) continue;
            return true;
        }
        return false;
    }

    public List<PackageLoadedVisitor> getPackageVisitors() {
        return this.packageVisitors;
    }

    protected TypeElementVisitor.VisitorKind getIncrementalProcessorKind() {
        String type = this.getIncrementalProcessorType();
        if (type.equals("org.gradle.annotation.processing.aggregating")) {
            return TypeElementVisitor.VisitorKind.AGGREGATING;
        }
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        if (this.packageVisitors.isEmpty()) {
            return Collections.emptySet();
        }
        return super.getSupportedAnnotationTypes();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.packageVisitors.isEmpty() || this.processingGeneratedAnnotation(annotations)) {
            return false;
        }
        LinkedHashSet<javax.lang.model.element.PackageElement> packageElements = new LinkedHashSet<javax.lang.model.element.PackageElement>();
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(typeElement);
            if (this.packageVisitors.isEmpty()) continue;
            for (Element element2 : annotatedElements) {
                if (!(element2 instanceof javax.lang.model.element.PackageElement)) continue;
                javax.lang.model.element.PackageElement packageElement = (javax.lang.model.element.PackageElement)element2;
                packageElements.add(packageElement);
            }
        }
        if (packageElements.isEmpty()) {
            return false;
        }
        JavaElementAnnotationMetadataFactory elementAnnotationMetadataFactory = this.javaVisitorContext.getElementAnnotationMetadataFactory();
        List list = packageElements.stream().map(element -> new JavaPackageElement((javax.lang.model.element.PackageElement)element, (ElementAnnotationMetadataFactory)elementAnnotationMetadataFactory, this.javaVisitorContext)).collect(Collectors.toCollection(() -> new ArrayList(packageElements.size())));
        if (!list.isEmpty()) {
            for (PackageLoadedVisitor packageVisitor : this.packageVisitors) {
                for (JavaPackageElement javaPackageElement : list) {
                    if (!packageVisitor.matches((AnnotationMetadata)javaPackageElement)) continue;
                    packageVisitor.visitor().visitPackage((PackageElement)javaPackageElement, (VisitorContext)this.javaVisitorContext);
                }
            }
        }
        if (roundEnv.processingOver()) {
            this.javaVisitorContext.finish();
        }
        return false;
    }

    private static @NonNull Collection<? extends PackageElementVisitor<?>> findPackageElementVisitors() {
        return SoftServiceLoader.load(PackageElementVisitor.class, (ClassLoader)PackageElementVisitorProcessor.class.getClassLoader()).disableFork().collectAll(Toggleable::isEnabled).stream().filter(Objects::nonNull).map(e -> e).collect(Collectors.toMap(Object::getClass, v -> v, (a, b) -> a)).values();
    }

    static {
        HashSet<String> names = new HashSet<String>();
        for (PackageElementVisitor<?> packageElementVisitor : PackageElementVisitorProcessor.findPackageElementVisitors()) {
            try {
                Set supportedAnnotationNames = packageElementVisitor.getSupportedAnnotationNames();
                if (supportedAnnotationNames.equals(Collections.singleton("*"))) continue;
                names.addAll(supportedAnnotationNames);
            }
            catch (Throwable throwable) {}
        }
        SUPPORTED_ANNOTATION_NAMES = names;
    }
}

