/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.PostponeToNextRoundException;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaEnumElement;
import io.micronaut.annotation.processing.visitor.JavaGenericPlaceholderElement;
import io.micronaut.annotation.processing.visitor.JavaNativeElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.annotation.processing.visitor.JavaWildcardElement;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.PrimitiveElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.ast.WildcardElement;
import io.micronaut.inject.ast.annotation.AbstractAnnotationElement;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;

@Internal
public abstract class AbstractJavaElement
extends AbstractAnnotationElement {
    protected final JavaVisitorContext visitorContext;
    private final JavaNativeElement nativeElement;

    AbstractJavaElement(JavaNativeElement nativeElement, ElementAnnotationMetadataFactory annotationMetadataFactory, JavaVisitorContext visitorContext) {
        super(annotationMetadataFactory);
        this.nativeElement = nativeElement;
        this.visitorContext = visitorContext;
    }

    protected abstract AbstractJavaElement copyThis();

    protected void copyValues(AbstractJavaElement element) {
        element.presetAnnotationMetadata = this.presetAnnotationMetadata;
    }

    protected final AbstractJavaElement makeCopy() {
        AbstractJavaElement element = this.copyThis();
        this.copyValues(element);
        return element;
    }

    public Element withAnnotationMetadata(AnnotationMetadata annotationMetadata) {
        AbstractJavaElement abstractJavaElement = this.makeCopy();
        abstractJavaElement.presetAnnotationMetadata = annotationMetadata;
        return abstractJavaElement;
    }

    public boolean isPackagePrivate() {
        javax.lang.model.element.Element element = this.nativeElement.element();
        Set<Object> modifiers = element != null ? element.getModifiers() : Collections.emptySet();
        return !modifiers.contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.PROTECTED) && !modifiers.contains((Object)Modifier.PRIVATE);
    }

    @NonNull
    public String getName() {
        javax.lang.model.element.Element element = this.nativeElement.element();
        return element != null ? element.getSimpleName().toString() : "";
    }

    public Set<ElementModifier> getModifiers() {
        javax.lang.model.element.Element element = this.nativeElement.element();
        if (element == null) {
            return Collections.emptySet();
        }
        return element.getModifiers().stream().map(m -> ElementModifier.valueOf((String)m.name())).collect(Collectors.toSet());
    }

    public Optional<String> getDocumentation() {
        String doc = this.visitorContext.getElements().getDocComment(this.nativeElement.element());
        return Optional.ofNullable(doc != null ? doc.trim() : null);
    }

    public boolean isAbstract() {
        return this.hasModifier(Modifier.ABSTRACT);
    }

    public boolean isStatic() {
        return this.hasModifier(Modifier.STATIC);
    }

    public boolean isPublic() {
        return this.hasModifier(Modifier.PUBLIC);
    }

    public boolean isPrivate() {
        return this.hasModifier(Modifier.PRIVATE);
    }

    public boolean isFinal() {
        return this.hasModifier(Modifier.FINAL);
    }

    public boolean isProtected() {
        return this.hasModifier(Modifier.PROTECTED);
    }

    @NonNull
    public JavaNativeElement getNativeType() {
        return this.nativeElement;
    }

    public String toString() {
        return Objects.requireNonNull(this.nativeElement.element()).toString();
    }

    @NonNull
    protected final ClassElement newClassElement(JavaNativeElement owner, TypeMirror type, Map<String, ClassElement> declaredElementTypeArguments) {
        return this.newClassElement(owner, type, declaredElementTypeArguments, new HashSet<TypeMirror>(), false);
    }

    @NonNull
    protected final ClassElement newClassElement(TypeMirror type, Map<String, ClassElement> declaredElementTypeArguments) {
        return this.newClassElement(null, type, declaredElementTypeArguments, new HashSet<TypeMirror>(), false);
    }

    @NonNull
    private ClassElement newClassElement(JavaNativeElement owner, TypeMirror type, Map<String, ClassElement> declaredTypeArguments, Set<TypeMirror> visitedTypes, boolean isTypeVariable) {
        return this.newClassElement(owner, type, declaredTypeArguments, visitedTypes, isTypeVariable, false, null);
    }

    @NonNull
    private ClassElement newClassElement(JavaNativeElement owner, TypeMirror type, Map<String, ClassElement> declaredTypeArguments, Set<TypeMirror> visitedTypes, boolean isTypeVariable, boolean isRawTypeParameter, @Nullable TypeParameterElement representedTypeParameter) {
        if (declaredTypeArguments == null) {
            declaredTypeArguments = Collections.emptyMap();
        }
        if (type instanceof NoType) {
            return PrimitiveElement.VOID;
        }
        if (type instanceof DeclaredType) {
            DeclaredType dt = (DeclaredType)type;
            javax.lang.model.element.Element element = dt.asElement();
            if (!(element.asType() instanceof DeclaredType)) {
                return this.newClassElement(owner, element.asType(), declaredTypeArguments, visitedTypes, isTypeVariable);
            }
            if (element instanceof TypeElement) {
                HashMap resolvedTypeArguments;
                TypeElement typeElement = (TypeElement)element;
                List<? extends TypeMirror> typeMirrorArguments = dt.getTypeArguments();
                if (visitedTypes.contains(dt) || typeElement.equals(this.nativeElement.element())) {
                    ClassElement objectElement = this.visitorContext.getClassElement(Object.class.getName()).orElseThrow(() -> new IllegalStateException("java.lang.Object element not found"));
                    List<? extends TypeParameterElement> typeParameters = typeElement.getTypeParameters();
                    HashMap resolved = CollectionUtils.newHashMap((int)typeMirrorArguments.size());
                    for (TypeParameterElement typeParameterElement : typeParameters) {
                        String variableName = typeParameterElement.getSimpleName().toString();
                        resolved.put(variableName, objectElement);
                    }
                    resolvedTypeArguments = resolved;
                } else {
                    visitedTypes.add(dt);
                    resolvedTypeArguments = this.resolveTypeArguments(typeElement.getTypeParameters(), typeMirrorArguments, declaredTypeArguments, visitedTypes);
                }
                if (type.getKind() == TypeKind.ERROR) {
                    throw new PostponeToNextRoundException(typeElement, this.getName() + " " + String.valueOf(typeElement));
                }
                if (this.visitorContext.getModelUtils().resolveKind(typeElement, ElementKind.ENUM).isPresent()) {
                    return new JavaEnumElement(new JavaNativeElement.Class(typeElement, type, owner), this.elementAnnotationMetadataFactory, this.visitorContext);
                }
                return new JavaClassElement(new JavaNativeElement.Class(typeElement, type, owner), this.elementAnnotationMetadataFactory, this.visitorContext, typeMirrorArguments, resolvedTypeArguments, 0, isTypeVariable);
            }
            return PrimitiveElement.VOID;
        }
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            return this.resolveTypeVariable(owner, declaredTypeArguments, visitedTypes, tv, isRawTypeParameter);
        }
        if (type instanceof ArrayType) {
            ArrayType at = (ArrayType)type;
            TypeMirror componentType = at.getComponentType();
            return this.newClassElement(owner, componentType, declaredTypeArguments, visitedTypes, isTypeVariable).toArray();
        }
        if (type instanceof PrimitiveType) {
            PrimitiveType pt = (PrimitiveType)type;
            return PrimitiveElement.valueOf((String)pt.getKind().name());
        }
        if (type instanceof WildcardType) {
            WildcardType wt = (WildcardType)type;
            return this.resolveWildcard(owner, declaredTypeArguments, visitedTypes, representedTypeParameter, wt);
        }
        return PrimitiveElement.VOID;
    }

    private ClassElement resolveWildcard(JavaNativeElement owner, Map<String, ClassElement> declaredTypeArguments, Set<TypeMirror> visitedTypes, TypeParameterElement representedTypeParameter, WildcardType wt) {
        ClassElement definedTypeBound;
        Stream<TypeMirror> upperBounds;
        Stream<TypeMirror> lowerBounds;
        TypeMirror superBound = wt.getSuperBound();
        if (superBound instanceof UnionType) {
            UnionType unionType = (UnionType)superBound;
            lowerBounds = unionType.getAlternatives().stream();
        } else {
            lowerBounds = Stream.ofNullable(superBound);
        }
        TypeMirror extendsBound = wt.getExtendsBound();
        if (extendsBound instanceof IntersectionType) {
            IntersectionType it = (IntersectionType)extendsBound;
            upperBounds = it.getBounds().stream();
        } else {
            upperBounds = extendsBound == null ? Stream.of(this.visitorContext.getElements().getTypeElement(Object.class.getName()).asType()) : Stream.of(extendsBound);
        }
        List<ClassElement> upperBoundsAsElements = upperBounds.map(tm -> this.newClassElement(owner, (TypeMirror)tm, declaredTypeArguments, visitedTypes, true)).toList();
        List<ClassElement> lowerBoundsAsElements = lowerBounds.map(tm -> this.newClassElement(owner, (TypeMirror)tm, declaredTypeArguments, visitedTypes, true)).toList();
        ClassElement upperType = WildcardElement.findUpperType(upperBoundsAsElements, lowerBoundsAsElements);
        if (upperType.getType().getName().equals(Object.class.getName()) && representedTypeParameter != null && (definedTypeBound = this.newClassElement(owner, representedTypeParameter.asType(), declaredTypeArguments, visitedTypes, true)) instanceof JavaGenericPlaceholderElement) {
            JavaGenericPlaceholderElement javaGenericPlaceholderElement = (JavaGenericPlaceholderElement)definedTypeBound;
            upperType = WildcardElement.findUpperType(javaGenericPlaceholderElement.getBounds(), Collections.emptyList());
        }
        if (upperType.isPrimitive()) {
            return upperType;
        }
        return new JavaWildcardElement(this.elementAnnotationMetadataFactory, wt, (JavaClassElement)upperType, upperBoundsAsElements.stream().map(JavaClassElement.class::cast).toList(), lowerBoundsAsElements.stream().map(JavaClassElement.class::cast).toList());
    }

    protected final Map<String, ClassElement> resolveTypeArguments(TypeElement typeElement, @Nullable List<? extends TypeMirror> typeMirrorArguments) {
        return this.resolveTypeArguments(typeElement.getTypeParameters(), typeMirrorArguments, Collections.emptyMap(), new HashSet<TypeMirror>());
    }

    protected final Map<String, ClassElement> resolveTypeArguments(ExecutableElement executableElement, Map<String, ClassElement> parentTypeArguments) {
        return this.resolveTypeArguments(executableElement.getTypeParameters(), null, parentTypeArguments, new HashSet<TypeMirror>());
    }

    private Map<String, ClassElement> resolveTypeArguments(List<? extends TypeParameterElement> typeParameters, @Nullable List<? extends TypeMirror> typeMirrorArguments, Map<String, ClassElement> parentTypeArguments, Set<TypeMirror> visitedTypes) {
        if (typeParameters.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap resolved = CollectionUtils.newLinkedHashMap((int)typeParameters.size());
        if (typeMirrorArguments != null && typeMirrorArguments.size() == typeParameters.size()) {
            Iterator<? extends TypeMirror> i = typeMirrorArguments.iterator();
            for (TypeParameterElement typeParameterElement : typeParameters) {
                TypeMirror typeParameterMirror = i.next();
                String variableName = typeParameterElement.getSimpleName().toString();
                resolved.put(variableName, this.newClassElement(this.getNativeType(), typeParameterMirror, parentTypeArguments, visitedTypes, typeParameterMirror instanceof TypeVariable, false, typeParameterElement));
            }
        } else {
            boolean isRaw = typeMirrorArguments != null;
            for (TypeParameterElement typeParameterElement : typeParameters) {
                String variableName = typeParameterElement.getSimpleName().toString();
                resolved.put(variableName, this.newClassElement(this.getNativeType(), typeParameterElement.asType(), parentTypeArguments, visitedTypes, true, isRaw, null));
            }
        }
        return resolved;
    }

    private ClassElement resolveTypeVariable(JavaNativeElement owner, Map<String, ClassElement> parentTypeArguments, Set<TypeMirror> visitedTypes, TypeVariable tv, boolean isRawType) {
        String variableName = tv.asElement().getSimpleName().toString();
        ClassElement resolvedBound = parentTypeArguments.get(variableName);
        ArrayList<JavaClassElement> bounds = null;
        AbstractJavaElement declaredElement = this;
        JavaClassElement resolved = null;
        int arrayDimensions = 0;
        if (resolvedBound != null) {
            if (resolvedBound instanceof WildcardElement) {
                WildcardElement wildcardElement = (WildcardElement)resolvedBound;
                if (wildcardElement.isBounded()) {
                    return wildcardElement;
                }
            } else if (resolvedBound instanceof JavaGenericPlaceholderElement) {
                JavaGenericPlaceholderElement javaGenericPlaceholderElement = (JavaGenericPlaceholderElement)resolvedBound;
                bounds = javaGenericPlaceholderElement.getBounds();
                declaredElement = javaGenericPlaceholderElement.getRequiredDeclaringElement();
                resolved = javaGenericPlaceholderElement.getResolvedInternal();
                isRawType = javaGenericPlaceholderElement.isRawType();
                arrayDimensions = javaGenericPlaceholderElement.getArrayDimensions();
            } else if (resolvedBound instanceof JavaClassElement) {
                JavaClassElement resolvedClassElement;
                resolved = resolvedClassElement = (JavaClassElement)resolvedBound;
                isRawType = resolvedClassElement.isRawType();
                arrayDimensions = resolvedClassElement.getArrayDimensions();
            } else {
                return resolvedBound;
            }
        }
        if (bounds == null) {
            List<TypeMirror> list;
            bounds = new ArrayList();
            TypeMirror upperBound = tv.getUpperBound();
            if (upperBound instanceof IntersectionType) {
                IntersectionType it = (IntersectionType)upperBound;
                list = it.getBounds();
            } else {
                list = Collections.singletonList(upperBound);
            }
            List<TypeMirror> boundsUnresolved = list;
            boundsUnresolved.stream().map(tm -> (JavaClassElement)this.newClassElement(owner, (TypeMirror)tm, parentTypeArguments, visitedTypes, true)).forEach(bounds::add);
        }
        return new JavaGenericPlaceholderElement(new JavaNativeElement.Placeholder(tv.asElement(), tv, this.getNativeType()), tv, (Element)declaredElement, resolved, bounds, this.elementAnnotationMetadataFactory, arrayDimensions, isRawType);
    }

    private boolean hasModifier(Modifier modifier) {
        return Objects.requireNonNull(this.nativeElement.element()).getModifiers().contains((Object)modifier);
    }

    public boolean equals(Object o) {
        TypedElement element;
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        Element that = (Element)o;
        if (that instanceof TypedElement && (element = (TypedElement)that).isPrimitive()) {
            return false;
        }
        if (!(that instanceof AbstractJavaElement)) {
            return false;
        }
        AbstractJavaElement abstractJavaElement = (AbstractJavaElement)that;
        return Objects.equals(this.nativeElement.element(), abstractJavaElement.getNativeType().element());
    }

    public int hashCode() {
        return Objects.requireNonNull(this.nativeElement.element()).hashCode();
    }
}

