/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.test;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import javax.tools.JavaFileObject;
import org.codehaus.groovy.runtime.IOGroovyMethods;

final class JavaFileObjectClassLoader
extends ClassLoader {
    private final Collection<JavaFileObject> files = new ArrayList<JavaFileObject>();

    public JavaFileObjectClassLoader(Iterable<? extends JavaFileObject> files) {
        for (JavaFileObject javaFileObject : files) {
            this.files.add(javaFileObject);
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String fileName = name.replace('.', '/') + ".class";
        JavaFileObject generated = this.files.stream().filter(it -> it.getName().endsWith(fileName)).findFirst().orElse(null);
        if (generated != null) {
            Class<?> clazz;
            block9: {
                InputStream io = generated.openInputStream();
                try {
                    byte[] bytes = IOGroovyMethods.getBytes((InputStream)io);
                    clazz = super.defineClass(name, bytes, 0, bytes.length);
                    if (io == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (io != null) {
                            try {
                                io.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return super.findClass(name);
                    }
                }
                io.close();
            }
            return clazz;
        }
        return super.findClass(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        String fileName = "/CLASS_OUTPUT/" + name;
        List<JavaFileObject> generated = this.files.stream().filter(it -> it.getName().startsWith(fileName)).toList();
        if (generated.isEmpty()) {
            return super.findResources(name);
        }
        return Collections.enumeration(generated.stream().map(javaFileObject -> {
            try {
                return new URL(null, javaFileObject.toUri().toString(), new URLStreamHandler(this, (JavaFileObject)javaFileObject){
                    final /* synthetic */ JavaFileObject val$javaFileObject;
                    {
                        this.val$javaFileObject = javaFileObject;
                    }

                    @Override
                    protected URLConnection openConnection(URL u) {
                        return new URLConnection(this, u){

                            @Override
                            public void connect() {
                            }

                            @Override
                            public InputStream getInputStream() throws IOException {
                                return val$javaFileObject.openInputStream();
                            }
                        };
                    }
                });
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList()));
    }
}

