/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.routes.rules;

import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.http.uri.UriMatchVariable;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.validation.routes.RouteValidationResult;
import io.micronaut.validation.routes.rules.RouteValidationRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class NullableParameterRule
implements RouteValidationRule {
    @Override
    public RouteValidationResult validate(List<UriMatchTemplate> templates, ParameterElement[] parameters, MethodElement method) {
        ArrayList errorMessages = new ArrayList();
        boolean isClient = method.hasAnnotation("io.micronaut.http.client.annotation.Client");
        if (!isClient) {
            HashMap<String, UriMatchVariable> variables = new HashMap<String, UriMatchVariable>();
            HashSet<UriMatchVariable> required = new HashSet<UriMatchVariable>();
            for (UriMatchTemplate template : templates) {
                for (UriMatchVariable variable : template.getVariables()) {
                    if (!variable.isOptional() || variable.isExploded()) {
                        required.add(variable);
                    }
                    variables.compute(variable.getName(), (key, var) -> {
                        if (var == null) {
                            if (variable.isOptional() && !variable.isExploded()) {
                                return variable;
                            }
                            return null;
                        }
                        if (!var.isOptional() || var.isExploded()) {
                            if (variable.isOptional() && !variable.isExploded()) {
                                return variable;
                            }
                            return var;
                        }
                        return var;
                    });
                }
            }
            for (UriMatchVariable variable : required) {
                if (!templates.stream().anyMatch(t -> !t.getVariableNames().contains(variable.getName()))) continue;
                variables.putIfAbsent(variable.getName(), variable);
            }
            for (UriMatchVariable variable : variables.values()) {
                Arrays.stream(parameters).flatMap(p -> this.getTypedElements((ParameterElement)p).stream()).filter(p -> p.getName().equals(variable.getName())).forEach(p -> {
                    ClassElement type = p.getType();
                    boolean hasDefaultValue = p.findAnnotation(Bindable.class).flatMap(av -> av.stringValue("defaultValue")).isPresent();
                    if (!(this.isNullable((TypedElement)p) || type == null || type.isAssignable(Optional.class) || hasDefaultValue)) {
                        errorMessages.add("The uri variable [%s] is optional, but the corresponding method argument [%s %s] is not defined as an Optional or annotated with a Nullable annotation.".formatted(variable.getName(), p.getType().toString(), p.getName()));
                    }
                });
            }
        }
        return new RouteValidationResult(errorMessages.toArray(StringUtils.EMPTY_STRING_ARRAY));
    }

    private boolean isNullable(TypedElement p) {
        return p.getAnnotationNames().stream().anyMatch(n -> NameUtils.getSimpleName((String)n).equals("Nullable"));
    }

    private List<TypedElement> getTypedElements(ParameterElement parameterElement) {
        if (parameterElement.hasAnnotation("io.micronaut.http.annotation.RequestBean")) {
            return parameterElement.getType().getBeanProperties().stream().filter(p -> p.hasStereotype(Bindable.class)).collect(Collectors.toList());
        }
        return Collections.singletonList(parameterElement);
    }
}

