/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server;

import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.http.filter.FilterRunner;
import io.micronaut.http.filter.GenericHttpFilter;
import io.micronaut.http.server.ExecutableRouteInfo;
import io.micronaut.http.server.RouteExecutor;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.NotAcceptableException;
import io.micronaut.http.server.exceptions.NotAllowedException;
import io.micronaut.http.server.exceptions.NotFoundException;
import io.micronaut.http.server.exceptions.NotWebSocketRequestException;
import io.micronaut.http.server.exceptions.UnsupportedMediaException;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.types.files.FileCustomizableResponseType;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.json.JsonSyntaxException;
import io.micronaut.web.router.DefaultRouteInfo;
import io.micronaut.web.router.DefaultUriRouteMatch;
import io.micronaut.web.router.RouteInfo;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.UriRouteMatch;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class RequestLifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(RequestLifecycle.class);
    private final RouteExecutor routeExecutor;
    private final boolean multipartEnabled;
    private HttpRequest<?> request;

    protected RequestLifecycle(RouteExecutor routeExecutor) {
        this.routeExecutor = Objects.requireNonNull(routeExecutor, "routeExecutor");
        Optional<Boolean> isMultiPartEnabled = routeExecutor.serverConfiguration.getMultipart().getEnabled();
        this.multipartEnabled = isMultiPartEnabled.isEmpty() || isMultiPartEnabled.get() != false;
    }

    @Deprecated(forRemoval=true, since="4.3.0")
    protected RequestLifecycle(RouteExecutor routeExecutor, HttpRequest<?> request) {
        this(routeExecutor);
        this.request = request;
    }

    @Deprecated(forRemoval=true, since="4.3.0")
    protected final ExecutionFlow<HttpResponse<?>> normalFlow() {
        return this.normalFlow(this.request);
    }

    @Deprecated(forRemoval=true, since="4.3.0")
    protected final HttpRequest<?> request() {
        return this.request;
    }

    @Deprecated(forRemoval=true, since="4.3.0")
    @Nullable
    protected FileCustomizableResponseType findFile() {
        return null;
    }

    protected final ExecutionFlow<HttpResponse<?>> normalFlow(HttpRequest<?> request) {
        try {
            MediaType contentType;
            Objects.requireNonNull(request, "request");
            if (!this.multipartEnabled && (contentType = (MediaType)request.getContentType().orElse(null)) != null && contentType.equals((Object)MediaType.MULTIPART_FORM_DATA_TYPE)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Multipart uploads have been disabled via configuration. Rejected request for URI {}, method {}, and content type {}", new Object[]{request.getUri(), request.getMethodName(), contentType});
                }
                return this.onStatusError(request, HttpResponse.status((HttpStatus)HttpStatus.UNSUPPORTED_MEDIA_TYPE), "Content Type [" + String.valueOf(contentType) + "] not allowed");
            }
            return this.runServerFilters(request);
        }
        catch (Throwable t) {
            return this.onError(request, t);
        }
    }

    private ExecutionFlow<HttpResponse<?>> executeRoute(HttpRequest<?> request, PropagatedContext propagatedContext, RouteMatch<?> routeMatch) {
        ExecutionFlow<RouteMatch<?>> routeMatchFlow = this.fulfillArguments(routeMatch, request);
        ExecutionFlow<HttpResponse<?>> responseFlow = this.callRoute(routeMatchFlow, request, propagatedContext);
        responseFlow = this.handleStatusException(responseFlow, request, routeMatch, propagatedContext);
        return this.onErrorNoFilter(responseFlow, request, propagatedContext);
    }

    private ExecutionFlow<HttpResponse<?>> callRoute(ExecutionFlow<RouteMatch<?>> flux, HttpRequest<?> filteredRequest, PropagatedContext propagatedContext) {
        RouteMatch routeMatch;
        Object o = flux.tryCompleteValue();
        if (o instanceof DefaultUriRouteMatch) {
            DefaultUriRouteMatch urm = (DefaultUriRouteMatch)o;
            v0 = urm;
        } else {
            v0 = routeMatch = (RouteMatch)o;
        }
        if (routeMatch != null) {
            return this.routeExecutor.callRoute(propagatedContext, routeMatch, filteredRequest);
        }
        return flux.flatMap(rm -> this.routeExecutor.callRoute(propagatedContext, (RouteMatch<?>)rm, filteredRequest));
    }

    private ExecutionFlow<HttpResponse<?>> handleStatusException(ExecutionFlow<HttpResponse<?>> flux, HttpRequest<?> request, RouteMatch<?> routeMatch, PropagatedContext propagatedContext) {
        HttpResponse response;
        Object o = flux.tryCompleteValue();
        if (o instanceof MutableHttpResponse) {
            MutableHttpResponse mut = (MutableHttpResponse)o;
            v0 = mut;
        } else {
            v0 = response = (HttpResponse)o;
        }
        if (response != null) {
            return this.handleStatusException(request, response, routeMatch, propagatedContext);
        }
        return flux.flatMap(res -> this.handleStatusException(request, (HttpResponse<?>)res, routeMatch, propagatedContext));
    }

    private ExecutionFlow<HttpResponse<?>> onErrorNoFilter(ExecutionFlow<HttpResponse<?>> flux, HttpRequest<?> request, PropagatedContext propagatedContext) {
        if (flux.tryCompleteValue() != null) {
            return flux;
        }
        Throwable throwable = flux.tryCompleteError();
        if (throwable != null) {
            return this.onErrorNoFilter(request, throwable, propagatedContext);
        }
        return flux.onErrorResume(exp -> this.onErrorNoFilter(request, (Throwable)exp, propagatedContext));
    }

    protected final ExecutionFlow<HttpResponse<?>> onError(HttpRequest<?> request, Throwable throwable) {
        try {
            return this.runWithFilters(request, (filteredRequest, propagatedContext) -> this.onErrorNoFilter((HttpRequest<?>)filteredRequest, throwable, (PropagatedContext)propagatedContext)).onErrorResume(t -> this.createDefaultErrorResponseFlow(request, (Throwable)t));
        }
        catch (Throwable e) {
            return this.createDefaultErrorResponseFlow(request, e);
        }
    }

    private ExecutionFlow<HttpResponse<?>> onErrorNoFilter(HttpRequest<?> request, Throwable t, PropagatedContext propagatedContext) {
        Throwable cause;
        RouteMatch<?> errorRoute;
        ConversionErrorException cee;
        Throwable throwable;
        if ((t instanceof CompletionException || t instanceof ExecutionException) && t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof ConversionErrorException && (throwable = (cee = (ConversionErrorException)t).getCause()) instanceof JsonSyntaxException) {
            JsonSyntaxException jse = (JsonSyntaxException)throwable;
            t = jse;
        }
        if ((errorRoute = this.routeExecutor.findErrorRoute(cause = t, this.findDeclaringType(request), request)) != null) {
            return this.handleErrorRoute(request, propagatedContext, errorRoute, cause);
        }
        Optional optionalDefinition = this.routeExecutor.beanContext.findBeanDefinition(ExceptionHandler.class, Qualifiers.byTypeArgumentsClosest((Class[])new Class[]{cause.getClass(), Object.class}));
        if (optionalDefinition.isPresent()) {
            BeanDefinition handlerDefinition = (BeanDefinition)optionalDefinition.get();
            return this.handlerExceptionHandler(request, propagatedContext, (BeanDefinition<ExceptionHandler>)handlerDefinition, cause);
        }
        if (RouteExecutor.isIgnorable(cause)) {
            RouteExecutor.logIgnoredException(cause);
            return ExecutionFlow.empty();
        }
        return this.createDefaultErrorResponseFlow(request, cause);
    }

    private Class<?> findDeclaringType(HttpRequest<?> request) {
        Optional previousRequestRouteInfo = request.getAttribute((CharSequence)HttpAttributes.ROUTE_INFO, RouteInfo.class);
        return previousRequestRouteInfo.map(RouteInfo::getDeclaringType).orElse(null);
    }

    private ExecutionFlow<HttpResponse<?>> handleErrorRoute(HttpRequest<?> request, PropagatedContext propagatedContext, RouteMatch<?> errorRoute, Throwable cause) {
        RouteExecutor.setRouteAttributes(request, errorRoute);
        if (this.routeExecutor.serverConfiguration.isLogHandledExceptions()) {
            this.routeExecutor.logException(cause);
        }
        try {
            return ExecutionFlow.just(errorRoute).flatMap(routeMatch -> this.routeExecutor.callRoute(propagatedContext, (RouteMatch<?>)routeMatch, request).flatMap(res -> this.handleStatusException(request, (HttpResponse<?>)res, (RouteMatch<?>)routeMatch, propagatedContext))).onErrorResume(u -> this.createDefaultErrorResponseFlow(request, (Throwable)u)).map(response -> {
                response.setAttribute((CharSequence)HttpAttributes.EXCEPTION, (Object)cause);
                return response;
            }).onErrorResume(throwable -> this.createDefaultErrorResponseFlow(request, (Throwable)throwable));
        }
        catch (Throwable e) {
            return this.createDefaultErrorResponseFlow(request, e);
        }
    }

    private ExecutionFlow<HttpResponse<?>> handlerExceptionHandler(HttpRequest<?> request, PropagatedContext propagatedContext, BeanDefinition<ExceptionHandler> handlerDefinition, Throwable cause) {
        Optional optionalMethod = handlerDefinition.findPossibleMethods("handle").findFirst();
        DefaultRouteInfo routeInfo = optionalMethod.isPresent() ? new ExecutableRouteInfo((ExecutableMethod)optionalMethod.get(), true) : new DefaultRouteInfo(AnnotationMetadata.EMPTY_METADATA, ReturnType.of(Object.class, (Argument[])new Argument[0]), List.of(), MediaType.fromType((Class)handlerDefinition.getBeanType()).map(Collections::singletonList).orElse(Collections.emptyList()), handlerDefinition.getBeanType(), true, false, MessageBodyHandlerRegistry.EMPTY);
        Supplier<ExecutionFlow> responseSupplier = () -> {
            ExceptionHandler handler = (ExceptionHandler)this.routeExecutor.beanContext.getBean(handlerDefinition);
            try {
                if (this.routeExecutor.serverConfiguration.isLogHandledExceptions()) {
                    this.routeExecutor.logException(cause);
                }
                Object result = handler.handle(request, cause);
                return this.routeExecutor.createResponseForBody(propagatedContext, request, result, (RouteInfo<?>)routeInfo, null);
            }
            catch (Throwable e) {
                return this.createDefaultErrorResponseFlow(request, e);
            }
        };
        ExecutorService executor = this.routeExecutor.findExecutor((RouteInfo<?>)routeInfo);
        ExecutionFlow responseFlow = executor != null ? ExecutionFlow.async((Executor)executor, responseSupplier) : responseSupplier.get();
        return responseFlow.map(response -> {
            response.setAttribute((CharSequence)HttpAttributes.EXCEPTION, (Object)cause);
            return response;
        }).onErrorResume(throwable -> this.createDefaultErrorResponseFlow(request, (Throwable)throwable));
    }

    protected final ExecutionFlow<HttpResponse<?>> runWithFilters(HttpRequest<?> request, BiFunction<HttpRequest<?>, PropagatedContext, ExecutionFlow<HttpResponse<?>>> responseProvider) {
        try {
            List httpFilters = this.routeExecutor.router.findFilters(request);
            FilterRunner filterRunner = new FilterRunner(httpFilters, responseProvider){

                protected ExecutionFlow<HttpResponse<?>> processResponse(HttpRequest<?> request, HttpResponse<?> response, PropagatedContext propagatedContext) {
                    RouteInfo routeInfo = response.getAttribute((CharSequence)HttpAttributes.ROUTE_INFO, RouteInfo.class).orElse(null);
                    return RequestLifecycle.this.handleStatusException(request, response, routeInfo, propagatedContext).onErrorResume(throwable -> RequestLifecycle.this.onErrorNoFilter(request, (Throwable)throwable, propagatedContext));
                }

                protected ExecutionFlow<HttpResponse<?>> processFailure(HttpRequest<?> request, Throwable failure, PropagatedContext propagatedContext) {
                    return RequestLifecycle.this.onErrorNoFilter(request, failure, propagatedContext);
                }
            };
            return filterRunner.run(request);
        }
        catch (Throwable e) {
            return ExecutionFlow.error((Throwable)e);
        }
    }

    private ExecutionFlow<HttpResponse<?>> runServerFilters(HttpRequest<?> request) {
        try {
            PropagatedContext propagatedContext = PropagatedContext.get();
            List preMatchingFilters = this.routeExecutor.router.findPreMatchingFilters(request);
            FilterRunner filterRunner = new FilterRunner(preMatchingFilters, null, null){
                UriRouteMatch<Object, Object> routeMatch;

                protected List<GenericHttpFilter> findFiltersAfterRouteMatch(HttpRequest<?> request) {
                    return RequestLifecycle.this.routeExecutor.router.findFilters(request);
                }

                protected ExecutionFlow<HttpResponse<?>> provideResponse(@NonNull HttpRequest<?> request, @NonNull PropagatedContext propagatedContext) {
                    if (this.routeMatch == null) {
                        FileCustomizableResponseType fileCustomizableResponseType = RequestLifecycle.this.findFile(request);
                        if (fileCustomizableResponseType != null) {
                            return ExecutionFlow.just((Object)HttpResponse.ok((Object)fileCustomizableResponseType));
                        }
                        return RequestLifecycle.this.onRouteMiss(request, propagatedContext);
                    }
                    if (this.routeMatch.getRouteInfo().isWebSocketRoute()) {
                        return RequestLifecycle.this.onStatusError(request, new NotWebSocketRequestException(), this.routeMatch.getDeclaringType(), propagatedContext);
                    }
                    return RequestLifecycle.this.executeRoute(request, propagatedContext, (RouteMatch<?>)this.routeMatch);
                }

                protected void doRouteMatch(HttpRequest<?> request) {
                    this.routeMatch = RequestLifecycle.this.routeExecutor.findRouteMatch(request);
                    if (this.routeMatch == null) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Not matched route for request {} - {}", (Object)request.getMethodName(), (Object)request.getUri().getPath());
                        }
                        return;
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Matched route {} - {} to controller {}", new Object[]{request.getMethodName(), request.getUri().getPath(), this.routeMatch.getDeclaringType()});
                    }
                    RouteExecutor.setRouteAttributes(request, this.routeMatch);
                }

                protected ExecutionFlow<HttpResponse<?>> processResponse(HttpRequest<?> request, HttpResponse<?> response, PropagatedContext propagatedContext) {
                    RouteInfo routeInfo = response.getAttribute((CharSequence)HttpAttributes.ROUTE_INFO, RouteInfo.class).orElse(null);
                    return RequestLifecycle.this.handleStatusException(request, response, routeInfo, propagatedContext).onErrorResume(throwable -> RequestLifecycle.this.onErrorNoFilter(request, (Throwable)throwable, propagatedContext));
                }

                protected ExecutionFlow<HttpResponse<?>> processFailure(HttpRequest<?> request, Throwable failure, PropagatedContext propagatedContext) {
                    return RequestLifecycle.this.onErrorNoFilter(request, failure, propagatedContext);
                }
            };
            return filterRunner.run(request, propagatedContext);
        }
        catch (Throwable e) {
            return ExecutionFlow.error((Throwable)e);
        }
    }

    private ExecutionFlow<HttpResponse<?>> handleStatusException(HttpRequest<?> request, HttpResponse<?> response, @Nullable RouteMatch<?> routeMatch, PropagatedContext propagatedContext) {
        if (response.code() < 400) {
            return ExecutionFlow.just(response);
        }
        RouteInfo routeInfo = routeMatch == null ? null : routeMatch.getRouteInfo();
        return this.handleStatusException(request, response, routeInfo, propagatedContext);
    }

    private ExecutionFlow<HttpResponse<?>> handleStatusException(HttpRequest<?> request, HttpResponse<?> response, RouteInfo<?> routeInfo, PropagatedContext propagatedContext) {
        RouteMatch<Object> statusRoute;
        if (response.code() >= 400 && routeInfo != null && !routeInfo.isErrorRoute() && (statusRoute = this.routeExecutor.findStatusRoute(request, response.code(), routeInfo)) != null) {
            return this.executeRoute(request, propagatedContext, statusRoute);
        }
        return ExecutionFlow.just(response);
    }

    private ExecutionFlow<HttpResponse<?>> createDefaultErrorResponseFlow(HttpRequest<?> httpRequest, Throwable cause) {
        return ExecutionFlow.just(this.routeExecutor.createDefaultErrorResponse(httpRequest, cause));
    }

    final ExecutionFlow<HttpResponse<?>> onRouteMiss(HttpRequest<?> httpRequest) {
        return this.onRouteMiss(httpRequest, PropagatedContext.getOrEmpty());
    }

    final ExecutionFlow<HttpResponse<?>> onRouteMiss(HttpRequest<?> httpRequest, PropagatedContext propagatedContext) {
        HttpMethod httpMethod = httpRequest.getMethod();
        String requestMethodName = httpRequest.getMethodName();
        MediaType contentType = httpRequest.getContentType().orElse(null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("No matching route: {} {}", (Object)httpMethod, (Object)httpRequest.getUri());
        }
        List anyMatchingRoutes = this.routeExecutor.router.findAny(httpRequest);
        Collection acceptedTypes = httpRequest.accept();
        boolean hasAcceptHeader = CollectionUtils.isNotEmpty((Collection)acceptedTypes);
        HashSet acceptableContentTypes = contentType != null ? new HashSet(5) : null;
        HashSet<String> allowedMethods = new HashSet<String>(5);
        HashSet produceableContentTypes = hasAcceptHeader ? new HashSet(5) : null;
        Class declaringType = null;
        for (UriRouteMatch anyRoute : anyMatchingRoutes) {
            String routeMethod = anyRoute.getRouteInfo().getHttpMethodName();
            if (!requestMethodName.equals(routeMethod)) {
                allowedMethods.add(routeMethod);
            }
            if (contentType != null && !anyRoute.getRouteInfo().doesConsume(contentType)) {
                acceptableContentTypes.addAll(anyRoute.getRouteInfo().getConsumes());
            }
            if (hasAcceptHeader && !anyRoute.getRouteInfo().doesProduce(acceptedTypes)) {
                produceableContentTypes.addAll(anyRoute.getRouteInfo().getProduces());
            }
            declaringType = anyRoute.getDeclaringType();
        }
        if (CollectionUtils.isNotEmpty(acceptableContentTypes)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Content type not allowed for URI {}, method {}, and content type {}", new Object[]{httpRequest.getUri(), requestMethodName, contentType});
            }
            return this.onStatusError(httpRequest, new UnsupportedMediaException(contentType.toString(), acceptableContentTypes.stream().map(MediaType::toString).toList()), declaringType, propagatedContext);
        }
        if (CollectionUtils.isNotEmpty(produceableContentTypes)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Content type not allowed for URI {}, method {}, and content type {}", new Object[]{httpRequest.getUri(), requestMethodName, contentType});
            }
            return this.onStatusError(httpRequest, new NotAcceptableException(acceptedTypes.stream().map(MediaType::toString).toList(), produceableContentTypes.stream().map(MediaType::toString).toList()), declaringType, propagatedContext);
        }
        if (!allowedMethods.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Method not allowed for URI {} and method {}", (Object)httpRequest.getUri(), (Object)requestMethodName);
            }
            return this.onStatusError(httpRequest, new NotAllowedException(requestMethodName, httpRequest.getUri(), allowedMethods), declaringType, propagatedContext);
        }
        return this.onStatusError(httpRequest, new NotFoundException(), declaringType, propagatedContext);
    }

    protected final ExecutionFlow<HttpResponse<?>> onStatusError(HttpRequest<?> request, MutableHttpResponse<?> defaultResponse, String message) {
        ExecutionFlow<HttpResponse<?>> flow = this.executionFlowWithStatusRoute(request, defaultResponse.getStatus());
        if (flow != null) {
            return flow;
        }
        if (request.getMethod() != HttpMethod.HEAD && (defaultResponse = this.routeExecutor.errorResponseProcessor.processResponse(ErrorContext.builder(request).errorMessage(message).build(), defaultResponse)).getContentType().isEmpty()) {
            defaultResponse = defaultResponse.contentType(MediaType.APPLICATION_JSON_TYPE);
        }
        return ExecutionFlow.just(defaultResponse);
    }

    @Nullable
    protected FileCustomizableResponseType findFile(HttpRequest<?> request) {
        return this.findFile();
    }

    protected ExecutionFlow<RouteMatch<?>> fulfillArguments(RouteMatch<?> routeMatch, HttpRequest<?> request) {
        try {
            this.routeExecutor.requestArgumentSatisfier.fulfillArgumentRequirementsBeforeFilters(routeMatch, request);
            return ExecutionFlow.just(routeMatch);
        }
        catch (Throwable e) {
            return ExecutionFlow.error((Throwable)e);
        }
    }

    @NonNull
    private ExecutionFlow<HttpResponse<?>> onStatusError(@NonNull HttpRequest<?> request, @NonNull HttpStatusException cause, @Nullable Class<?> declaringType, @NonNull PropagatedContext propagatedContext) {
        ExecutionFlow<HttpResponse<?>> flow = this.executionFlowWithStatusRoute(request, cause.getStatus());
        if (flow != null) {
            return flow;
        }
        flow = this.executionFlowWithErrorRoute(request, cause, declaringType, propagatedContext);
        if (flow != null) {
            return flow;
        }
        flow = this.executionFlowWithExceptionHandler(request, cause, propagatedContext);
        if (flow != null) {
            return flow;
        }
        throw new ConfigurationException("no status route for status " + String.valueOf(cause.getStatus()) + " or exception handler or error route for " + cause.getClass().getName());
    }

    @Nullable
    private ExecutionFlow<HttpResponse<?>> executionFlowWithExceptionHandler(@NonNull HttpRequest<?> request, @NonNull HttpStatusException cause, @NonNull PropagatedContext propagatedContext) {
        return this.routeExecutor.beanContext.findBeanDefinition(ExceptionHandler.class, Qualifiers.byTypeArgumentsClosest((Class[])new Class[]{cause.getClass(), Object.class})).map(handlerDefinition -> this.handlerExceptionHandler(request, propagatedContext, (BeanDefinition<ExceptionHandler>)handlerDefinition, (Throwable)cause)).orElse(null);
    }

    @Nullable
    private ExecutionFlow<HttpResponse<?>> executionFlowWithErrorRoute(@NonNull HttpRequest<?> request, @NonNull HttpStatusException cause, @Nullable Class<?> declaringType, @NonNull PropagatedContext propagatedContext) {
        RouteMatch<?> errorRoute;
        if (declaringType == null) {
            declaringType = this.findDeclaringType(request);
        }
        return (errorRoute = this.routeExecutor.findErrorRoute((Throwable)cause, declaringType, request)) != null ? this.handleErrorRoute(request, propagatedContext, errorRoute, (Throwable)cause) : null;
    }

    @Nullable
    private ExecutionFlow<HttpResponse<?>> executionFlowWithStatusRoute(@NonNull HttpRequest<?> request, @NonNull HttpStatus status) {
        return this.routeExecutor.router.findStatusRoute(status, request).map(routeMatch -> this.executeRoute(request, PropagatedContext.getOrEmpty(), (RouteMatch<?>)routeMatch)).orElse(null);
    }
}

