/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.handler.accesslog.element;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.server.netty.handler.accesslog.element.ConnectionMetadata;
import io.netty.channel.Channel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.unix.DomainSocketChannel;
import io.netty.handler.codec.quic.QuicChannel;
import java.net.SocketAddress;
import java.util.Optional;
import org.jspecify.annotations.NonNull;

@Internal
final class ConnectionMetadataImpl {
    static final Class<?> QUIC_CHANNEL;
    static final Class<?> DOMAIN_SOCKET_ADDRESS;
    static final Class<?> DOMAIN_SOCKET_CHANNEL;

    ConnectionMetadataImpl() {
    }

    static {
        Class<DomainSocketChannel> domainSocketChannelClass;
        Class<DomainSocketAddress> domainSocketAddressClass;
        Class<QuicChannel> quicChannelClass;
        try {
            quicChannelClass = QuicChannel.class;
        }
        catch (Exception e) {
            quicChannelClass = null;
        }
        QUIC_CHANNEL = quicChannelClass;
        try {
            domainSocketAddressClass = DomainSocketAddress.class;
            domainSocketChannelClass = DomainSocketChannel.class;
        }
        catch (Exception e) {
            domainSocketAddressClass = null;
            domainSocketChannelClass = null;
        }
        DOMAIN_SOCKET_ADDRESS = domainSocketAddressClass;
        DOMAIN_SOCKET_CHANNEL = domainSocketChannelClass;
    }

    @Internal
    public static final class Empty
    implements ConnectionMetadata {
        static final ConnectionMetadata INSTANCE = new Empty();

        @Override
        public @NonNull Optional<SocketAddress> localAddress() {
            return Optional.empty();
        }

        @Override
        public @NonNull Optional<SocketAddress> remoteAddress() {
            return Optional.empty();
        }
    }

    @Internal
    record QuicChannelMetadata(Channel ch) implements ConnectionMetadata
    {
        @Override
        public @NonNull Optional<SocketAddress> localAddress() {
            return Optional.ofNullable(((QuicChannel)this.ch).localSocketAddress());
        }

        @Override
        public @NonNull Optional<SocketAddress> remoteAddress() {
            return Optional.ofNullable(((QuicChannel)this.ch).remoteSocketAddress());
        }
    }

    @Internal
    record GenericChannelMetadata(Channel ch) implements ConnectionMetadata
    {
        @Override
        public @NonNull Optional<SocketAddress> localAddress() {
            return Optional.of(this.ch.localAddress());
        }

        @Override
        public @NonNull Optional<SocketAddress> remoteAddress() {
            return Optional.of(this.ch.remoteAddress());
        }
    }

    @Internal
    record SocketChannelMetadata(SocketChannel ch) implements ConnectionMetadata
    {
        @Override
        public @NonNull Optional<SocketAddress> localAddress() {
            return Optional.of(this.ch.localAddress());
        }

        @Override
        public @NonNull Optional<SocketAddress> remoteAddress() {
            return Optional.of(this.ch.remoteAddress());
        }
    }

    static class DomainSocketUtil {
        DomainSocketUtil() {
        }

        static String getPath(SocketAddress address) {
            return ((DomainSocketAddress)address).path();
        }
    }
}

