/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.binders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.http.bind.binders.PendingRequestBindingResult;
import io.micronaut.http.bind.binders.TypedRequestArgumentBinder;
import io.micronaut.http.multipart.CompletedFileUpload;
import io.micronaut.http.multipart.FileUpload;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.binders.NettyRequestArgumentBinder;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import reactor.core.publisher.Mono;

@Internal
final class NettyCompletedFileUploadBinder
implements TypedRequestArgumentBinder<CompletedFileUpload>,
NettyRequestArgumentBinder<CompletedFileUpload> {
    private static final Argument<CompletedFileUpload> STREAMING_FILE_UPLOAD_ARGUMENT = Argument.of(CompletedFileUpload.class);
    private final ConversionService conversionService;

    NettyCompletedFileUploadBinder(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public List<Class<?>> superTypes() {
        return List.of(FileUpload.class);
    }

    @Override
    public ArgumentBinder.BindingResult<CompletedFileUpload> bindForNettyRequest(ArgumentConversionContext<CompletedFileUpload> context, NettyHttpRequest<?> request) {
        if (request.getContentType().isEmpty() || !request.isFormOrMultipartData()) {
            return ArgumentBinder.BindingResult.unsatisfied();
        }
        Argument argument = context.getArgument();
        String inputName = argument.getAnnotationMetadata().stringValue(Bindable.NAME).orElse(argument.getName());
        final CompletableFuture completableFuture = Mono.from(request.formRouteCompleter().claimFieldsComplete(inputName)).map(d -> (CompletedFileUpload)this.conversionService.convertRequired((Object)d, CompletedFileUpload.class)).toFuture();
        return new PendingRequestBindingResult<CompletedFileUpload>(this){

            public boolean isPending() {
                return !completableFuture.isDone();
            }

            public Optional<CompletedFileUpload> getValue() {
                return Optional.ofNullable(completableFuture.getNow(null));
            }
        };
    }

    public Argument<CompletedFileUpload> argumentType() {
        return STREAMING_FILE_UPLOAD_ARGUMENT;
    }
}

