/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.binders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.http.bind.binders.PendingRequestBindingResult;
import io.micronaut.http.bind.binders.TypedRequestArgumentBinder;
import io.micronaut.http.multipart.PartData;
import io.micronaut.http.multipart.StreamingFileUpload;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.binders.NettyRequestArgumentBinder;
import io.micronaut.http.server.netty.multipart.NettyStreamingFileUpload;
import io.netty.handler.codec.http.multipart.FileUpload;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Internal
final class NettyStreamingFileUploadBinder
implements TypedRequestArgumentBinder<StreamingFileUpload>,
NettyRequestArgumentBinder<StreamingFileUpload> {
    private static final Argument<StreamingFileUpload> STREAMING_FILE_UPLOAD_ARGUMENT = Argument.of(StreamingFileUpload.class);
    private final NettyStreamingFileUpload.Factory fileUploadFactory;

    NettyStreamingFileUploadBinder(NettyStreamingFileUpload.Factory fileUploadFactory) {
        this.fileUploadFactory = fileUploadFactory;
    }

    @Override
    public ArgumentBinder.BindingResult<StreamingFileUpload> bindForNettyRequest(ArgumentConversionContext<StreamingFileUpload> context, NettyHttpRequest<?> request) {
        Argument argument = context.getArgument();
        String inputName = argument.getAnnotationMetadata().stringValue(Bindable.NAME).orElse(argument.getName());
        final CompletableFuture completableFuture = Mono.from(request.formRouteCompleter().claimFields(inputName, (data, publisher) -> this.fileUploadFactory.create((FileUpload)data, (Flux<PartData>)publisher))).toFuture();
        return new PendingRequestBindingResult<StreamingFileUpload>(this){

            public boolean isPending() {
                return !completableFuture.isDone();
            }

            public Optional<StreamingFileUpload> getValue() {
                return Optional.ofNullable(completableFuture.getNow(null));
            }
        };
    }

    public Argument<StreamingFileUpload> argumentType() {
        return STREAMING_FILE_UPLOAD_ARGUMENT;
    }
}

