/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.execution.ImperativeExecutionFlow;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.netty.NettyMutableHttpResponse;
import io.micronaut.http.netty.body.NettyByteBodyFactory;
import io.micronaut.http.server.RequestLifecycle;
import io.micronaut.http.server.netty.FormDataHttpContentProcessor;
import io.micronaut.http.server.netty.FormRouteCompleter;
import io.micronaut.http.server.netty.HttpContentProcessorAsReactiveProcessor;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.RoutingInBoundHandler;
import io.micronaut.http.server.netty.handler.OutboundAccess;
import io.micronaut.http.server.types.files.FileCustomizableResponseType;
import io.micronaut.http.server.types.files.StreamedFile;
import io.micronaut.http.server.types.files.SystemFile;
import io.micronaut.web.router.RouteMatch;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpContent;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
final class NettyRequestLifecycle
extends RequestLifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(NettyRequestLifecycle.class);
    private final RoutingInBoundHandler rib;
    private final OutboundAccess outboundAccess;
    private NettyHttpRequest<?> nettyRequest;

    NettyRequestLifecycle(RoutingInBoundHandler rib, OutboundAccess outboundAccess) {
        super(rib.routeExecutor);
        this.rib = rib;
        this.outboundAccess = outboundAccess;
    }

    void handleNormal(NettyHttpRequest<?> request) {
        ExecutionFlow result;
        DecoderResult decoderResult;
        this.nettyRequest = request;
        if (LOG.isDebugEnabled()) {
            HttpMethod httpMethod = request.getMethod();
            LOG.debug("Request {} {}", (Object)httpMethod, (Object)request.getUri());
        }
        if ((decoderResult = request.getNativeRequest().decoderResult()).isFailure()) {
            Throwable cause = decoderResult.cause();
            HttpStatus status = cause instanceof TooLongFrameException ? HttpStatus.REQUEST_ENTITY_TOO_LARGE : HttpStatus.BAD_REQUEST;
            try {
                result = this.onStatusError(request, HttpResponse.status((HttpStatus)status), status.getReason());
            }
            catch (Exception e) {
                result = ExecutionFlow.error((Throwable)e);
            }
        } else {
            try {
                result = this.normalFlow(request);
            }
            catch (Exception e) {
                this.handleException(request, e);
                return;
            }
        }
        ImperativeExecutionFlow imperativeFlow = result.tryComplete();
        if (imperativeFlow != null) {
            HttpResponse httpResponse;
            Object value = imperativeFlow.getValue();
            if (value instanceof NettyMutableHttpResponse) {
                NettyMutableHttpResponse mut = (NettyMutableHttpResponse)value;
                httpResponse = mut;
            } else {
                httpResponse = (HttpResponse)value;
            }
            HttpResponse response2 = httpResponse;
            this.rib.writeResponse(this.outboundAccess, request, response2, imperativeFlow.getError());
        } else {
            result.onComplete((response, throwable) -> this.rib.writeResponse(this.outboundAccess, request, (HttpResponse<?>)response, (Throwable)throwable));
        }
    }

    protected @Nullable FileCustomizableResponseType findFile(HttpRequest<?> request) {
        Optional optionalUrl = this.rib.staticResourceResolver.resolve(request.getUri().getPath());
        if (optionalUrl.isPresent()) {
            try {
                File file;
                URL url = (URL)optionalUrl.get();
                if (url.getProtocol().equals("file") && (file = Paths.get(url.toURI()).toFile()).exists() && !file.isDirectory() && file.canRead()) {
                    return new SystemFile(file);
                }
                return new StreamedFile(url);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    protected ExecutionFlow<RouteMatch<?>> fulfillArguments(RouteMatch<?> routeMatch, HttpRequest<?> request) {
        DecoderResult decoderResult = this.nettyRequest.getNativeRequest().decoderResult();
        if (decoderResult.isFailure()) {
            return ExecutionFlow.error((Throwable)decoderResult.cause());
        }
        return super.fulfillArguments(routeMatch, request).flatMap(this::waitForBody);
    }

    private ExecutionFlow<RouteMatch<?>> waitForBody(RouteMatch<?> routeMatch) {
        if (this.nettyRequest.hasFormRouteCompleter()) {
            FormDataHttpContentProcessor processor = new FormDataHttpContentProcessor(this.nettyRequest, this.rib.serverConfiguration);
            ByteBody rootBody = this.nettyRequest.byteBody();
            FormRouteCompleter formRouteCompleter = this.nettyRequest.formRouteCompleter();
            try {
                HttpContentProcessorAsReactiveProcessor.asPublisher(processor, (Publisher<HttpContent>)NettyByteBodyFactory.toByteBufs((ByteBody)rootBody).map(DefaultHttpContent::new)).subscribe((Subscriber)formRouteCompleter);
                this.nettyRequest.addRouteWaitsFor((ExecutionFlow<?>)formRouteCompleter.getExecute());
            }
            catch (Throwable e) {
                return ExecutionFlow.error((Throwable)e);
            }
        }
        return this.nettyRequest.getRouteWaitsFor().map(v -> routeMatch);
    }

    void handleException(NettyHttpRequest<?> nettyRequest, Throwable cause) {
        this.onError(nettyRequest, cause).onComplete((response, throwable) -> this.rib.writeResponse(this.outboundAccess, nettyRequest, (HttpResponse<?>)response, (Throwable)throwable));
    }
}

