/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpParameters;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.netty.NettyHttpParameters;
import io.micronaut.http.netty.NettyHttpRequestBuilder;
import io.micronaut.http.netty.stream.DefaultStreamedHttpRequest;
import io.micronaut.http.netty.stream.StreamedHttpRequest;
import io.micronaut.web.router.uri.UriUtil;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.DefaultAttributeMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import org.jspecify.annotations.NonNull;

@Internal
public abstract class AbstractNettyHttpRequest<B>
extends DefaultAttributeMap
implements HttpRequest<B>,
NettyHttpRequestBuilder {
    protected final io.netty.handler.codec.http.HttpRequest nettyRequest;
    protected final ConversionService conversionService;
    protected final HttpMethod httpMethod;
    protected final String unvalidatedUrl;
    protected final String httpMethodName;
    private volatile URI uri;
    private volatile NettyHttpParameters httpParameters;
    private volatile Charset charset;
    private volatile String path;

    public AbstractNettyHttpRequest(io.netty.handler.codec.http.HttpRequest nettyRequest, ConversionService conversionService, boolean escapeHtmlUrl) {
        this.nettyRequest = nettyRequest;
        this.conversionService = conversionService;
        String uri = nettyRequest.uri();
        if (!UriUtil.isValidPath((String)uri)) {
            if (escapeHtmlUrl && UriUtil.isRelative((String)uri)) {
                uri = UriUtil.toValidPath((String)uri);
            }
            this.uri = AbstractNettyHttpRequest.createURI(uri);
        }
        this.unvalidatedUrl = uri;
        this.httpMethodName = nettyRequest.method().name();
        this.httpMethod = HttpMethod.parse((String)this.httpMethodName);
    }

    public @NonNull io.netty.handler.codec.http.HttpRequest toHttpRequest() {
        return this.nettyRequest;
    }

    public @NonNull FullHttpRequest toFullHttpRequest() {
        io.netty.handler.codec.http.HttpRequest httpRequest = this.nettyRequest;
        if (httpRequest instanceof FullHttpRequest) {
            FullHttpRequest request = (FullHttpRequest)httpRequest;
            return request;
        }
        DefaultFullHttpRequest httpRequest2 = new DefaultFullHttpRequest(this.nettyRequest.protocolVersion(), this.nettyRequest.method(), this.nettyRequest.uri());
        httpRequest2.headers().setAll(this.nettyRequest.headers());
        return httpRequest2;
    }

    public @NonNull StreamedHttpRequest toStreamHttpRequest() {
        if (this.isStream()) {
            return (StreamedHttpRequest)this.nettyRequest;
        }
        io.netty.handler.codec.http.HttpRequest httpRequest = this.nettyRequest;
        if (httpRequest instanceof FullHttpRequest) {
            FullHttpRequest request = (FullHttpRequest)httpRequest;
            return new DefaultStreamedHttpRequest(HttpVersion.HTTP_1_1, this.nettyRequest.method(), this.nettyRequest.uri(), true, Publishers.just((Object)new DefaultLastHttpContent(request.content())));
        }
        return new DefaultStreamedHttpRequest(HttpVersion.HTTP_1_1, this.nettyRequest.method(), this.nettyRequest.uri(), true, Publishers.just((Object)LastHttpContent.EMPTY_LAST_CONTENT));
    }

    public boolean isStream() {
        return this.nettyRequest instanceof StreamedHttpRequest;
    }

    public io.netty.handler.codec.http.HttpRequest getNettyRequest() {
        return this.nettyRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpParameters getParameters() {
        NettyHttpParameters params = this.httpParameters;
        if (params == null) {
            AbstractNettyHttpRequest abstractNettyHttpRequest = this;
            synchronized (abstractNettyHttpRequest) {
                params = this.httpParameters;
                if (params == null) {
                    this.httpParameters = params = this.decodeParameters();
                }
            }
        }
        return params;
    }

    public Charset getCharacterEncoding() {
        if (this.charset == null) {
            this.charset = this.initCharset(super.getCharacterEncoding());
        }
        return this.charset;
    }

    public HttpMethod getMethod() {
        return this.httpMethod;
    }

    public URI getUri() {
        URI u = this.uri;
        if (u == null) {
            this.uri = u = AbstractNettyHttpRequest.createURI(this.unvalidatedUrl);
        }
        return u;
    }

    public String getPath() {
        String p = this.path;
        if (p == null) {
            this.path = p = AbstractNettyHttpRequest.parsePath(this.unvalidatedUrl);
        }
        return p;
    }

    protected abstract Charset initCharset(Charset var1);

    protected abstract int getMaxParams();

    protected abstract boolean isSemicolonIsNormalChar();

    protected final QueryStringDecoder createDecoder(URI uri) {
        Charset cs = this.getCharacterEncoding();
        boolean semicolonIsNormalChar = this.isSemicolonIsNormalChar();
        int maxParams = this.getMaxParams();
        return cs != null ? new QueryStringDecoder(uri, cs, maxParams, semicolonIsNormalChar) : new QueryStringDecoder(uri, HttpConstants.DEFAULT_CHARSET, maxParams, semicolonIsNormalChar);
    }

    private NettyHttpParameters decodeParameters() {
        QueryStringDecoder queryStringDecoder = this.createDecoder(this.getUri());
        return new NettyHttpParameters(queryStringDecoder.parameters(), this.conversionService, null);
    }

    public String getMethodName() {
        return this.httpMethodName;
    }

    private static URI createURI(String url) {
        URI fullUri = URI.create(url);
        if (fullUri.getAuthority() != null || fullUri.getScheme() != null) {
            try {
                fullUri = new URI(null, null, fullUri.getPath(), fullUri.getQuery(), fullUri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return fullUri;
    }

    private static String parsePath(String uri) {
        int i;
        if (uri.isEmpty()) {
            return "";
        }
        if (uri.charAt(0) == '/') {
            i = 0;
        } else {
            i = uri.indexOf("://");
            if (i == -1) {
                i = 0;
            } else if ((i = uri.indexOf(47, i + 3)) == -1) {
                return "/";
            }
        }
        int queryStart = uri.indexOf(63, i);
        if (queryStart == -1) {
            queryStart = uri.length();
            if (i == 0) {
                return uri;
            }
        }
        return uri.substring(i, queryStart);
    }
}

