/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.handler.accesslog.element;

import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.ServerCookieDecoder;
import io.micronaut.http.server.netty.handler.accesslog.element.AbstractHttpMessageLogElement;
import io.micronaut.http.server.netty.handler.accesslog.element.LogElement;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.List;
import java.util.StringJoiner;

final class CookiesElement
extends AbstractHttpMessageLogElement {
    public static final String REQUEST_COOKIES = "C";
    public static final String RESPONSE_COOKIES = "c";
    private static final CookiesElement REQUEST_COOKIES_ELEMENT = new CookiesElement("Cookie");
    private static final CookiesElement RESPONSE_COOKIES_ELEMENT = new CookiesElement("Set-Cookie");
    private final String headerName;

    private CookiesElement(String headerName) {
        this.headerName = "Cookie".equals(headerName) || "Set-Cookie".equals(headerName) ? headerName : "Cookie";
        this.events = "Cookie".equals(this.headerName) ? LogElement.Event.REQUEST_HEADERS_EVENTS : LogElement.Event.RESPONSE_HEADERS_EVENTS;
    }

    public static CookiesElement forRequest() {
        return REQUEST_COOKIES_ELEMENT;
    }

    public static CookiesElement forResponse() {
        return RESPONSE_COOKIES_ELEMENT;
    }

    @Override
    protected String value(HttpHeaders headers) {
        String header = headers.get(this.headerName);
        if (header != null) {
            List cookies = ServerCookieDecoder.INSTANCE.decode(header);
            if (cookies.isEmpty()) {
                return "-";
            }
            if (cookies.size() == 1) {
                Cookie cookie = (Cookie)cookies.iterator().next();
                return cookie.getName() + ":" + cookie.getValue();
            }
            StringJoiner joiner = new StringJoiner(",", "[", "]");
            for (Cookie cookie : cookies) {
                joiner.add(cookie.getName() + ":" + cookie.getValue());
            }
            return joiner.toString();
        }
        return "-";
    }

    public String toString() {
        return "%" + ("Cookie".equals(this.headerName) ? REQUEST_COOKIES : RESPONSE_COOKIES);
    }
}

