/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.ssl;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.ssl.AbstractServerSslBuilder;
import io.micronaut.http.server.netty.ssl.BuildSelfSignedCondition;
import io.micronaut.http.server.netty.ssl.ServerSslBuilder;
import io.micronaut.http.server.netty.ssl.SslEnabledCondition;
import io.micronaut.http.ssl.ServerSslConfiguration;
import io.micronaut.http.ssl.SslConfiguration;
import io.micronaut.runtime.context.scope.refresh.RefreshEvent;
import io.micronaut.runtime.context.scope.refresh.RefreshEventListener;
import jakarta.inject.Singleton;
import java.security.KeyStore;
import java.util.Optional;
import java.util.Set;

@Requirements(value={@Requires(condition=SslEnabledCondition.class), @Requires(condition=SelfSignedNotConfigured.class)})
@Singleton
@Internal
public class CertificateProvidedSslBuilder
extends AbstractServerSslBuilder
implements ServerSslBuilder,
RefreshEventListener,
Ordered {
    private final ServerSslConfiguration ssl;
    private KeyStore keyStoreCache = null;
    private KeyStore trustStoreCache = null;

    public CertificateProvidedSslBuilder(HttpServerConfiguration httpServerConfiguration, ServerSslConfiguration ssl, ResourceResolver resourceResolver) {
        super(resourceResolver, httpServerConfiguration);
        this.ssl = ssl;
    }

    @Override
    public ServerSslConfiguration getSslConfiguration() {
        return this.ssl;
    }

    protected Optional<KeyStore> getTrustStore(SslConfiguration ssl) throws Exception {
        if (this.trustStoreCache == null) {
            super.getTrustStore(ssl).ifPresent(trustStore -> {
                this.trustStoreCache = trustStore;
            });
        }
        return Optional.ofNullable(this.trustStoreCache);
    }

    protected Optional<KeyStore> getKeyStore(SslConfiguration ssl) throws Exception {
        if (this.keyStoreCache == null) {
            super.getKeyStore(ssl).ifPresent(keyStore -> {
                this.keyStoreCache = keyStore;
            });
        }
        return Optional.ofNullable(this.keyStoreCache);
    }

    public Set<String> getObservedConfigurationPrefixes() {
        return CollectionUtils.setOf((Object[])new String[]{"micronaut.ssl", "micronaut.server.ssl"});
    }

    public void onApplicationEvent(RefreshEvent event) {
        this.keyStoreCache = null;
        this.trustStoreCache = null;
    }

    public int getOrder() {
        return -2147483458;
    }

    static class SelfSignedNotConfigured
    extends BuildSelfSignedCondition {
        SelfSignedNotConfigured() {
        }

        @Override
        protected boolean validate(ConditionContext context, boolean deprecatedPropertyFound, boolean newPropertyFound) {
            if (deprecatedPropertyFound) {
                context.fail("Deprecated  micronaut.ssl.build-self-signed config detected, disabling provided certificate.");
                return false;
            }
            if (newPropertyFound) {
                context.fail("micronaut.server.ssl.build-self-signed config detected, disabling provided certificate.");
                return false;
            }
            return true;
        }
    }
}

