/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.handler.accesslog.element;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.server.netty.handler.accesslog.element.ConnectionMetadata;
import io.micronaut.http.server.netty.handler.accesslog.element.LogElement;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.Set;

final class RemoteHostElement
implements LogElement {
    public static final String REMOTE_HOST = "h";
    static final RemoteHostElement INSTANCE = new RemoteHostElement();

    private RemoteHostElement() {
    }

    @Override
    public Set<LogElement.Event> events() {
        return LogElement.Event.REQUEST_HEADERS_EVENTS;
    }

    @Override
    public String onRequestHeaders(@NonNull ConnectionMetadata metadata, @NonNull String method, @NonNull HttpHeaders headers, @NonNull String uri, @NonNull String protocol) {
        return metadata.remoteAddress().flatMap(ConnectionMetadata::getHostName).orElse("-");
    }

    @Override
    public LogElement copy() {
        return this;
    }

    public String toString() {
        return "%h";
    }
}

