/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.types.files;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.netty.NettyMutableHttpResponse;
import io.micronaut.http.server.netty.types.NettyCustomizableResponseTypeHandler;
import io.micronaut.http.server.netty.types.NettyFileCustomizableResponseType;
import io.micronaut.http.server.netty.types.files.FileTypeHandlerConfiguration;
import io.micronaut.http.server.netty.types.files.NettyStreamedFileCustomizableResponseType;
import io.micronaut.http.server.netty.types.files.NettySystemFileCustomizableResponseType;
import io.micronaut.http.server.types.CustomizableResponseTypeException;
import io.micronaut.http.server.types.files.StreamedFile;
import io.micronaut.http.server.types.files.SystemFile;
import io.micronaut.http.server.types.files.SystemFileCustomizableResponseType;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpResponse;
import java.io.File;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import javax.inject.Singleton;

@Singleton
public class FileTypeHandler
implements NettyCustomizableResponseTypeHandler<Object> {
    private static final Class<?>[] SUPPORTED_TYPES = new Class[]{File.class, SystemFileCustomizableResponseType.class, StreamedFile.class, NettyFileCustomizableResponseType.class, SystemFile.class};
    private final FileTypeHandlerConfiguration configuration;

    public FileTypeHandler(FileTypeHandlerConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void handle(Object obj, HttpRequest<?> request, NettyMutableHttpResponse<?> response, ChannelHandlerContext context) {
        long fileLastModifiedSeconds;
        long ifModifiedSinceDateSeconds;
        NettyFileCustomizableResponseType type;
        if (obj instanceof File) {
            type = new NettySystemFileCustomizableResponseType((File)obj);
        } else if (obj instanceof NettyFileCustomizableResponseType) {
            type = (NettyFileCustomizableResponseType)obj;
        } else if (obj instanceof SystemFileCustomizableResponseType) {
            type = new NettySystemFileCustomizableResponseType((SystemFileCustomizableResponseType)obj);
        } else if (obj instanceof StreamedFile) {
            type = new NettyStreamedFileCustomizableResponseType((StreamedFile)obj);
        } else if (obj instanceof SystemFile) {
            type = new NettySystemFileCustomizableResponseType((SystemFile)obj);
        } else {
            throw new CustomizableResponseTypeException("FileTypeHandler only supports File or FileCustomizableResponseType types");
        }
        long lastModified = type.getLastModified();
        ZonedDateTime ifModifiedSince = request.getHeaders().getDate((CharSequence)"If-Modified-Since");
        if (ifModifiedSince != null && (ifModifiedSinceDateSeconds = ifModifiedSince.toEpochSecond()) == (fileLastModifiedSeconds = lastModified / 1000L)) {
            FullHttpResponse nettyResponse = this.notModified();
            context.writeAndFlush((Object)nettyResponse);
            return;
        }
        if (!response.getHeaders().contains("Content-Type")) {
            response.header((CharSequence)"Content-Type", (CharSequence)type.getMediaType().toString());
        }
        this.setDateAndCacheHeaders((MutableHttpResponse)response, lastModified);
        type.process((MutableHttpResponse)response);
        type.write((HttpRequest)request, (MutableHttpResponse)response, context);
        context.read();
    }

    @Override
    public boolean supports(Class<?> type) {
        return Arrays.stream(SUPPORTED_TYPES).anyMatch(aClass -> aClass.isAssignableFrom(type));
    }

    @Deprecated
    protected MediaType getMediaType(String filename) {
        return MediaType.TEXT_PLAIN_TYPE;
    }

    protected void setDateAndCacheHeaders(MutableHttpResponse response, long lastModified) {
        MutableHttpHeaders headers = response.getHeaders();
        LocalDateTime now = LocalDateTime.now();
        headers.date(now);
        LocalDateTime cacheSeconds = now.plus(this.configuration.getCacheSeconds(), ChronoUnit.SECONDS);
        if (response.header((CharSequence)"Expires") == null) {
            headers.expires(cacheSeconds);
        }
        if (response.header((CharSequence)"Cache-Control") == null) {
            FileTypeHandlerConfiguration.CacheControlConfiguration cacheConfig = this.configuration.getCacheControl();
            StringBuilder header = new StringBuilder(cacheConfig.getPublic() ? "public" : "private");
            header.append(", max-age=");
            header.append(this.configuration.getCacheSeconds());
            response.header((CharSequence)"Cache-Control", (CharSequence)header.toString());
        }
        if (response.header((CharSequence)"Last-Modified") == null) {
            headers.lastModified(lastModified);
        }
    }

    protected void setDateHeader(MutableHttpResponse response) {
        MutableHttpHeaders headers = response.getHeaders();
        LocalDateTime now = LocalDateTime.now();
        headers.date(now);
    }

    private FullHttpResponse notModified() {
        NettyMutableHttpResponse response = (NettyMutableHttpResponse)HttpResponse.notModified();
        this.setDateHeader((MutableHttpResponse)response);
        return response.getNativeResponse();
    }
}

