/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.configuration;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.netty.util.ResourceLeakDetector;
import org.jspecify.annotations.Nullable;

@ConfigurationProperties(value="netty")
@BootstrapContextCompatible
public class NettyGlobalConfiguration {
    private static final boolean DEFAULT_THREAD_FACTORY_REACTOR_NON_BLOCKING = true;
    private static final boolean DEFAULT_THREAD_FACTORY_DAEMON = false;
    private static final int DEFAULT_THREAD_FACTORY_PRIORITY = 5;
    private ResourceLeakDetector.Level resourceLeakDetectorLevel;
    private boolean defaultThreadFactoryReactorNonBlocking = true;
    private boolean defaultThreadFactoryDaemon = false;
    private int defaultThreadFactoryPriority = 5;

    public void setResourceLeakDetectorLevel(ResourceLeakDetector.Level resourceLeakDetectorLevel) {
        this.resourceLeakDetectorLevel = resourceLeakDetectorLevel;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ResourceLeakDetector.Level getResourceLeakDetectorLevel() {
        return this.resourceLeakDetectorLevel;
    }

    public boolean isDefaultThreadFactoryReactorNonBlocking() {
        return this.defaultThreadFactoryReactorNonBlocking;
    }

    public void setDefaultThreadFactoryReactorNonBlocking(boolean defaultThreadFactoryReactorNonBlocking) {
        this.defaultThreadFactoryReactorNonBlocking = defaultThreadFactoryReactorNonBlocking;
    }

    public boolean isDefaultThreadFactoryDaemon() {
        return this.defaultThreadFactoryDaemon;
    }

    public void setDefaultThreadFactoryDaemon(boolean defaultThreadFactoryDaemon) {
        this.defaultThreadFactoryDaemon = defaultThreadFactoryDaemon;
    }

    public int getDefaultThreadFactoryPriority() {
        return this.defaultThreadFactoryPriority;
    }

    public void setDefaultThreadFactoryPriority(int defaultThreadFactoryPriority) {
        if (defaultThreadFactoryPriority < 1 || defaultThreadFactoryPriority > 10) {
            throw new IllegalArgumentException("defaultThreadFactoryPriority: " + defaultThreadFactoryPriority + " (expected: Thread.MIN_PRIORITY <= defaultThreadFactoryPriority <= Thread.MAX_PRIORITY)");
        }
        this.defaultThreadFactoryPriority = defaultThreadFactoryPriority;
    }
}

