/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.channel.loom;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.netty.channel.loom.LoomBranchSupport;
import io.micronaut.http.netty.channel.loom.LoomCarrierGroup;
import io.micronaut.http.netty.channel.loom.PrivateLoomSupport;
import io.micronaut.scheduling.LoomSupport;
import io.netty.util.AttributeMap;
import io.netty.util.concurrent.EventExecutor;
import java.util.concurrent.Executor;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Internal
public sealed interface EventLoopVirtualThreadScheduler
permits LoomCarrierGroup.IoScheduler, LoomCarrierGroup.Runner, LoomCarrierGroup.StickyScheduler {
    public @NonNull AttributeMap attributeMap();

    public @NonNull EventExecutor eventLoop();

    public static @Nullable EventLoopVirtualThreadScheduler current() {
        if (LoomBranchSupport.isSupported()) {
            if (!LoomSupport.isVirtual((Thread)Thread.currentThread())) {
                return null;
            }
            LoomBranchSupport.VirtualThreadSchedulerProxy virtualThreadSchedulerProxy = LoomBranchSupport.currentScheduler();
            if (virtualThreadSchedulerProxy instanceof EventLoopVirtualThreadScheduler) {
                EventLoopVirtualThreadScheduler elvts = (EventLoopVirtualThreadScheduler)((Object)virtualThreadSchedulerProxy);
                return elvts;
            }
            return null;
        }
        if (PrivateLoomSupport.isSupported()) {
            Thread thread = Thread.currentThread();
            if (!LoomSupport.isVirtual((Thread)thread)) {
                return null;
            }
            Executor executor = PrivateLoomSupport.getScheduler(thread);
            if (executor instanceof EventLoopVirtualThreadScheduler) {
                EventLoopVirtualThreadScheduler elvts = (EventLoopVirtualThreadScheduler)((Object)executor);
                return elvts;
            }
            return null;
        }
        return null;
    }
}

