/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.ssl.ClientAuthentication;
import io.micronaut.http.ssl.SslConfiguration;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSslCachingX509KeyManagerFactory;
import io.netty.handler.ssl.OpenSslX509KeyManagerFactory;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Optional;
import javax.net.ssl.KeyManagerFactory;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Internal
public final class NettyTlsUtils {
    public static boolean useOpenssl(SslConfiguration sslConfiguration) {
        return sslConfiguration.isPreferOpenssl() && SslProvider.isAlpnSupported((SslProvider)SslProvider.OPENSSL_REFCNT);
    }

    public static SslProvider sslProvider(SslConfiguration sslConfiguration) {
        return NettyTlsUtils.useOpenssl(sslConfiguration) ? SslProvider.OPENSSL_REFCNT : SslProvider.JDK;
    }

    public static @NonNull KeyManagerFactory storeToFactory(@NonNull SslConfiguration ssl, @Nullable KeyStore keyStore) throws Exception {
        Object keyManagerFactory = NettyTlsUtils.useOpenssl(ssl) ? (keyStore == null || keyStore.aliases().hasMoreElements() ? new OpenSslX509KeyManagerFactory() : new OpenSslCachingX509KeyManagerFactory(KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm()))) : KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        Optional password = ssl.getKey().getPassword();
        char[] keyPassword = password.map(String::toCharArray).orElse(null);
        Optional pwd = ssl.getKeyStore().getPassword();
        if (keyPassword == null && pwd.isPresent()) {
            keyPassword = ((String)pwd.get()).toCharArray();
        }
        if (keyStore != null && ssl.getKey().getAlias().isPresent()) {
            keyStore = NettyTlsUtils.extractKeystoreAlias(keyStore, (String)ssl.getKey().getAlias().get(), keyPassword);
        }
        ((KeyManagerFactory)keyManagerFactory).init(keyStore, keyPassword);
        return keyManagerFactory;
    }

    private static @NonNull KeyStore extractKeystoreAlias(@NonNull KeyStore rootKeystore, @NonNull String alias, @Nullable char[] password) throws Exception {
        if (!rootKeystore.containsAlias(alias)) {
            throw new IllegalArgumentException("Alias " + alias + " not found in keystore");
        }
        Key key = rootKeystore.getKey(alias, password);
        if (key == null) {
            throw new IllegalStateException("There are no keys associated with the alias " + alias);
        }
        Certificate[] certChain = rootKeystore.getCertificateChain(alias);
        KeyStore aliasKeystore = KeyStore.getInstance(rootKeystore.getType());
        aliasKeystore.load(null, null);
        aliasKeystore.setKeyEntry(alias, key, password, certChain);
        return aliasKeystore;
    }

    public static void setupServerBuilder(SslContextBuilder sslBuilder, SslConfiguration ssl, HttpVersion httpVersion) {
        sslBuilder.sslProvider(NettyTlsUtils.sslProvider(ssl));
        Optional protocols = ssl.getProtocols();
        if (protocols.isPresent()) {
            sslBuilder.protocols((String[])protocols.get());
        }
        boolean isHttp2 = httpVersion == HttpVersion.HTTP_2_0;
        Optional ciphers = ssl.getCiphers();
        if (ciphers.isPresent()) {
            sslBuilder = sslBuilder.ciphers(Arrays.asList((String[])ciphers.get()));
        } else if (isHttp2) {
            sslBuilder.ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE);
        }
        Optional clientAuthentication = ssl.getClientAuthentication();
        if (clientAuthentication.isPresent()) {
            ClientAuthentication clientAuth = (ClientAuthentication)clientAuthentication.get();
            if (clientAuth == ClientAuthentication.NEED) {
                sslBuilder.clientAuth(ClientAuth.REQUIRE);
            } else if (clientAuth == ClientAuthentication.WANT) {
                sslBuilder.clientAuth(ClientAuth.OPTIONAL);
            }
        }
        if (isHttp2) {
            sslBuilder.applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"}));
        }
    }
}

