/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.channel;

import io.micronaut.context.BeanLocator;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.netty.channel.DefaultEventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.EventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.EventLoopGroupFactory;
import io.micronaut.http.netty.channel.EventLoopGroupRegistry;
import io.micronaut.http.netty.channel.NettyThreadFactory;
import io.micronaut.http.netty.channel.TaskQueueInterceptor;
import io.micronaut.http.netty.channel.loom.LoomCarrierGroup;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.IoEventLoop;
import io.netty.channel.IoEventLoopGroup;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.SingleThreadIoEventLoop;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.ThreadPerTaskExecutor;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
@Internal
@BootstrapContextCompatible
public class DefaultEventLoopGroupRegistry
implements EventLoopGroupRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEventLoopGroupRegistry.class);
    private final EventLoopGroupFactory eventLoopGroupFactory;
    private final BeanLocator beanLocator;
    private final Map<EventLoopGroup, EventLoopGroupConfiguration> eventLoopGroups = new ConcurrentHashMap<EventLoopGroup, EventLoopGroupConfiguration>();
    private final BeanProvider<LoomCarrierGroup.Factory> loomCarrierGroupFactory;
    private final List<TaskQueueInterceptor> taskQueueInterceptors;

    public DefaultEventLoopGroupRegistry(EventLoopGroupFactory eventLoopGroupFactory, BeanLocator beanLocator, BeanProvider<LoomCarrierGroup.Factory> loomCarrierGroupFactory, List<TaskQueueInterceptor> taskQueueInterceptors) {
        this.eventLoopGroupFactory = eventLoopGroupFactory;
        this.beanLocator = beanLocator;
        this.loomCarrierGroupFactory = loomCarrierGroupFactory;
        this.taskQueueInterceptors = taskQueueInterceptors;
    }

    @PreDestroy
    void shutdown() {
        this.eventLoopGroups.forEach((eventLoopGroup, configuration) -> {
            block2: {
                try {
                    long quietPeriod = configuration.getShutdownQuietPeriod().toMillis();
                    long timeout = configuration.getShutdownTimeout().toMillis();
                    eventLoopGroup.shutdownGracefully(quietPeriod, timeout, TimeUnit.MILLISECONDS);
                }
                catch (Throwable t) {
                    if (!LOG.isWarnEnabled()) break block2;
                    LOG.warn("Error shutting down EventLoopGroup: {}", (Object)t.getMessage(), (Object)t);
                }
            }
        });
        this.eventLoopGroups.clear();
    }

    private EventLoopGroup createGroup(EventLoopGroupConfiguration configuration, final String name, Executor executor) {
        IoHandlerFactory ioHandlerFactory = this.eventLoopGroupFactory.createIoHandlerFactory(configuration);
        int nThreads = DefaultEventLoopGroupRegistry.numThreads(configuration);
        Object eventLoopGroup = configuration.isLoomCarrier() ? ((LoomCarrierGroup.Factory)this.loomCarrierGroupFactory.get()).create(nThreads, executor, ioHandlerFactory) : (this.taskQueueInterceptors.isEmpty() ? new MultiThreadIoEventLoopGroup(nThreads, executor, ioHandlerFactory) : new MultiThreadIoEventLoopGroup(this, nThreads, executor, ioHandlerFactory){
            final /* synthetic */ DefaultEventLoopGroupRegistry this$0;
            {
                this.this$0 = this$0;
                super(nThreads, executor, ioHandlerFactory);
            }

            protected IoEventLoop newChild(Executor executor, IoHandlerFactory ioHandlerFactory, Object ... args) {
                return new SingleThreadIoEventLoop(this, (IoEventLoopGroup)this, executor, ioHandlerFactory){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        super(parent, executor, ioHandlerFactory);
                    }

                    protected Queue<Runnable> newTaskQueue(int maxPendingTasks) {
                        Queue<Runnable> tq = super.newTaskQueue(maxPendingTasks);
                        for (TaskQueueInterceptor taskQueueInterceptor : this.this$1.this$0.taskQueueInterceptors) {
                            tq = taskQueueInterceptor.wrapTaskQueue(name, tq);
                        }
                        return tq;
                    }
                };
            }
        });
        this.eventLoopGroups.put((EventLoopGroup)eventLoopGroup, configuration);
        return eventLoopGroup;
    }

    @EachBean(value=EventLoopGroupConfiguration.class)
    @Bean
    @BootstrapContextCompatible
    protected EventLoopGroup eventLoopGroup(EventLoopGroupConfiguration configuration) {
        Executor executor;
        String executorName = configuration.getExecutorName().orElse(null);
        if (executorName != null) {
            executor = (Executor)this.beanLocator.findBean(Executor.class, Qualifiers.byName((String)executorName)).orElseThrow(() -> new ConfigurationException("No executor service configured for name: " + executorName));
        } else {
            ThreadFactory threadFactory = this.beanLocator.findBean(ThreadFactory.class, Qualifiers.byName((String)configuration.getName())).orElseGet(() -> new DefaultThreadFactory(configuration.getName() + "-" + DefaultThreadFactory.toPoolName(NioEventLoopGroup.class)));
            if (threadFactory instanceof NettyThreadFactory.EventLoopCustomizableThreadFactory) {
                NettyThreadFactory.EventLoopCustomizableThreadFactory custom = (NettyThreadFactory.EventLoopCustomizableThreadFactory)threadFactory;
                threadFactory = custom.customizeForEventLoop();
            }
            executor = new ThreadPerTaskExecutor(threadFactory);
        }
        return this.createGroup(configuration, configuration.getName(), executor);
    }

    @Singleton
    @Requires(missingProperty="micronaut.netty.event-loops.default")
    @Primary
    @BootstrapContextCompatible
    @Bean(typed={EventLoopGroup.class})
    protected EventLoopGroup defaultEventLoopGroup(@Named(value="netty") ThreadFactory threadFactory) {
        if (threadFactory instanceof NettyThreadFactory.EventLoopCustomizableThreadFactory) {
            NettyThreadFactory.EventLoopCustomizableThreadFactory custom = (NettyThreadFactory.EventLoopCustomizableThreadFactory)threadFactory;
            threadFactory = custom.customizeForEventLoop();
        }
        return this.createGroup(new DefaultEventLoopGroupConfiguration(), "default", (Executor)new ThreadPerTaskExecutor(threadFactory));
    }

    @Override
    public @NonNull EventLoopGroup getDefaultEventLoopGroup() {
        return (EventLoopGroup)this.beanLocator.getBean(EventLoopGroup.class);
    }

    @Override
    public Optional<EventLoopGroup> getEventLoopGroup(@NonNull String name) {
        ArgumentUtils.requireNonNull((String)"name", (Object)name);
        if ("default".equals(name)) {
            return this.beanLocator.findBean(EventLoopGroup.class);
        }
        return this.beanLocator.findBean(EventLoopGroup.class, Qualifiers.byName((String)name));
    }

    @Override
    public Optional<EventLoopGroupConfiguration> getEventLoopGroupConfiguration(@NonNull String name) {
        ArgumentUtils.requireNonNull((String)"name", (Object)name);
        return this.beanLocator.findBean(EventLoopGroupConfiguration.class, Qualifiers.byName((String)name));
    }

    public static int numThreads(EventLoopGroupConfiguration configuration) {
        int explicit = configuration.getNumThreads();
        if (explicit != 0) {
            return explicit;
        }
        return Math.toIntExact(Math.round(configuration.getThreadCoreRatio() * (double)NettyRuntime.availableProcessors()));
    }
}

