/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.body;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.buffer.netty.NettyReadBufferFactory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ReadBuffer;
import io.micronaut.http.body.AvailableByteBody;
import io.micronaut.http.body.CloseableAvailableByteBody;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.InternalByteBody;
import io.micronaut.http.body.stream.AvailableByteArrayBody;
import io.micronaut.http.body.stream.BaseSharedBuffer;
import io.micronaut.http.body.stream.BodySizeLimits;
import io.micronaut.http.netty.body.NettyByteBodyFactory;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.EventLoop;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Internal
@Deprecated(since="4.10.0", forRemoval=true)
public final class AvailableNettyByteBody
extends InternalByteBody
implements CloseableAvailableByteBody {
    private final long length;
    private @Nullable ByteBuf buffer;

    public AvailableNettyByteBody(@NonNull ByteBuf buffer) {
        this.buffer = Objects.requireNonNull(buffer, "buffer");
        this.length = buffer.readableBytes();
    }

    public static CloseableAvailableByteBody empty() {
        return AvailableByteArrayBody.create((ReadBuffer)NettyReadBufferFactory.of((ByteBufAllocator)ByteBufAllocator.DEFAULT).createEmpty());
    }

    public static @NonNull ByteBuf toByteBuf(@NonNull AvailableByteBody body) {
        return NettyByteBodyFactory.toByteBuf(body);
    }

    public static @NonNull CloseableByteBody createChecked(@NonNull EventLoop loop, @NonNull BodySizeLimits bodySizeLimits, @NonNull ByteBuf buf) {
        return new NettyByteBodyFactory(buf.alloc(), loop).createChecked(bodySizeLimits, buf);
    }

    public ByteBuf peek() {
        ByteBuf b = this.buffer;
        if (b == null) {
            this.failClaim();
        }
        return b;
    }

    public @NonNull InputStream toInputStream() {
        return new ByteBufInputStream(this.claim(), true);
    }

    public long length() {
        return this.length;
    }

    private @NonNull ByteBuf claim() {
        ByteBuf b = this.buffer;
        if (b == null) {
            this.failClaim();
        }
        this.recordPrimaryOp();
        this.buffer = null;
        BaseSharedBuffer.logClaim();
        return b;
    }

    public @NonNull ExecutionFlow<? extends CloseableAvailableByteBody> bufferFlow() {
        return ExecutionFlow.just((Object)((Object)new AvailableNettyByteBody(this.claim())));
    }

    public void close() {
        ByteBuf b = this.buffer;
        this.buffer = null;
        if (b != null) {
            this.recordClosed();
            b.release();
        }
    }

    public @NonNull Publisher<ReadBuffer> toReadBufferPublisher() {
        return Flux.just((Object)NettyReadBufferFactory.of((ByteBufAllocator)ByteBufAllocator.DEFAULT).adapt(this.claim()));
    }

    public byte @NonNull [] toByteArray() {
        ByteBuf b = this.claim();
        try {
            byte[] byArray = ByteBufUtil.getBytes((ByteBuf)b);
            return byArray;
        }
        finally {
            b.release();
        }
    }

    public @NonNull ByteBuffer<?> toByteBuffer() {
        return NettyByteBufferFactory.DEFAULT.wrap(this.claim());
    }

    public @NonNull CloseableByteBody move() {
        return new AvailableNettyByteBody(this.claim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull String toString(Charset charset) {
        ByteBuf b = this.claim();
        try {
            String string = b.toString(charset);
            return string;
        }
        finally {
            b.release();
        }
    }

    public @NonNull CloseableAvailableByteBody split() {
        ByteBuf b = this.buffer;
        if (b == null) {
            this.failClaim();
        }
        return new AvailableNettyByteBody(b.retainedSlice());
    }

    public void touch() {
        ByteBuf b = this.buffer;
        if (b != null) {
            b.touch();
        }
    }
}

