/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty;

import io.micronaut.context.BeanProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.http.netty.NettySslContextBuilder;
import io.micronaut.http.netty.NettyTlsUtils;
import io.micronaut.http.netty.SslContextHolder;
import io.micronaut.http.ssl.CertificateProvider;
import io.micronaut.http.ssl.SslConfiguration;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.security.KeyStore;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.util.function.Tuples;

@Internal
public abstract class SslContextAutoLoader {
    private final Logger log;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private @Nullable SslContextHolder current;
    private Disposable refreshSslDisposable;
    private long generation;

    protected SslContextAutoLoader(Logger log) {
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replace(@Nullable SslContextHolder holder, long gen) {
        this.rwLock.writeLock().lock();
        try {
            if (gen < this.generation) {
                if (holder != null) {
                    holder.release();
                }
                return;
            }
            assert (gen == this.generation);
            if (this.current != null) {
                this.current.release();
            }
            this.current = holder;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public final @Nullable SslContextHolder takeRetained() {
        this.rwLock.readLock().lock();
        try {
            if (this.current != null) {
                this.current.retain();
            }
            SslContextHolder sslContextHolder = this.current;
            return sslContextHolder;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public final void clear() {
        Disposable d;
        this.rwLock.writeLock().lock();
        try {
            d = this.refreshSslDisposable;
            this.refreshSslDisposable = null;
            if (this.current != null) {
                this.current.release();
                this.current = null;
            }
            ++this.generation;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        if (d != null) {
            d.dispose();
        }
    }

    protected abstract @NonNull BeanProvider<CertificateProvider> certificateProviders();

    protected abstract @NonNull SslConfiguration sslConfiguration();

    protected abstract boolean quic();

    protected abstract @NonNull SslContextHolder createLegacy();

    public final void autoLoad() {
        this.autoLoad(this.sslConfiguration().getKeyName(), this.sslConfiguration().getTrustName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void autoLoad(@Nullable String keyName, @Nullable String trustName) {
        Disposable nextDisposable;
        Disposable d;
        long gen;
        this.rwLock.writeLock().lock();
        try {
            gen = ++this.generation;
            d = this.refreshSslDisposable;
            this.refreshSslDisposable = null;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        if (d != null) {
            d.dispose();
        }
        if (keyName == null && trustName == null) {
            this.replace(this.createLegacy(), gen);
            nextDisposable = null;
        } else if (keyName != null && trustName != null) {
            CertificateProvider keyProvider = (CertificateProvider)this.certificateProviders().get(Qualifiers.byName((String)keyName));
            CertificateProvider trustProvider = (CertificateProvider)this.certificateProviders().get(Qualifiers.byName((String)trustName));
            nextDisposable = Flux.combineLatest((Publisher)keyProvider.getKeyStore(), (Publisher)trustProvider.getTrustStore(), Tuples::of).subscribe(tuple -> this.refreshSsl((KeyStore)tuple.getT1(), (KeyStore)tuple.getT2(), gen));
        } else if (keyName != null) {
            CertificateProvider keyProvider = (CertificateProvider)this.certificateProviders().get(Qualifiers.byName((String)keyName));
            nextDisposable = Flux.from((Publisher)keyProvider.getKeyStore()).subscribe(ks -> this.refreshSsl((KeyStore)ks, null, gen));
        } else {
            CertificateProvider trustProvider = (CertificateProvider)this.certificateProviders().get(Qualifiers.byName((String)trustName));
            nextDisposable = Flux.from((Publisher)trustProvider.getTrustStore()).subscribe(ts -> this.refreshSsl(null, (KeyStore)ts, gen));
        }
        if (nextDisposable != null) {
            this.rwLock.writeLock().lock();
            try {
                if (this.generation == gen) {
                    this.refreshSslDisposable = nextDisposable;
                } else {
                    nextDisposable.dispose();
                }
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
        }
    }

    protected abstract @NonNull NettySslContextBuilder builder();

    private void refreshSsl(@Nullable KeyStore ks, @Nullable KeyStore ts, long gen) {
        try {
            NettySslContextBuilder builder = this.builder().openssl(NettyTlsUtils.useOpenssl(this.sslConfiguration())).keyStore(ks).keyPassword(this.sslConfiguration().getKey().getPassword().or(() -> this.sslConfiguration().getKeyStore().getPassword()).orElse(null)).trustStore(ts).clientAuthentication(this.sslConfiguration().getClientAuthentication().orElse(null)).ciphers(this.sslConfiguration().getCiphers().map(List::of).orElse(null), false).protocols(this.sslConfiguration().getProtocols().map(List::of).orElse(null));
            this.replace(this.quic() ? new SslContextHolder(null, builder.buildHttp3()) : new SslContextHolder(builder.buildTcp(), null), gen);
        }
        catch (Exception e) {
            this.log.warn("Failed to initialize SSL context", (Throwable)e);
        }
    }
}

