/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.body;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.ByteBodyHttpResponse;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.body.ByteBodyFactory;
import io.micronaut.http.body.ChunkedMessageBodyReader;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.MessageBodyHandler;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.body.ResponseBodyWriter;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.netty.body.JsonChunkedProcessor;
import io.micronaut.json.JsonFeatures;
import io.micronaut.json.JsonMapper;
import io.micronaut.json.body.CustomizableJsonHandler;
import io.micronaut.json.body.JsonMessageHandler;
import io.netty.buffer.ByteBuf;
import jakarta.inject.Singleton;
import java.io.InputStream;
import java.io.OutputStream;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Order(value=-10)
@Singleton
@Internal
@Replaces(value=JsonMessageHandler.class)
@JsonMessageHandler.ProducesJson
@JsonMessageHandler.ConsumesJson
@BootstrapContextCompatible
@Requires(beans={JsonMapper.class})
public final class NettyJsonHandler<T>
implements MessageBodyHandler<T>,
ChunkedMessageBodyReader<T>,
CustomizableJsonHandler,
ResponseBodyWriter<T> {
    private final JsonMessageHandler<T> jsonMessageHandler;

    public NettyJsonHandler(JsonMapper jsonMapper) {
        this(new JsonMessageHandler(jsonMapper));
    }

    private NettyJsonHandler(JsonMessageHandler<T> jsonMessageHandler) {
        this.jsonMessageHandler = jsonMessageHandler;
    }

    public CustomizableJsonHandler customize(JsonFeatures jsonFeatures) {
        return new NettyJsonHandler<T>(this.jsonMessageHandler.getJsonMapper().cloneWithFeatures(jsonFeatures));
    }

    public Publisher<T> readChunked(Argument<T> type, MediaType mediaType, Headers httpHeaders, Publisher<ByteBuffer<?>> input) {
        JsonChunkedProcessor processor = new JsonChunkedProcessor();
        if (Iterable.class.isAssignableFrom(type.getType())) {
            processor.counter.noTokenization();
        } else {
            processor.counter.unwrapTopLevelArray();
        }
        return processor.process((Flux<ByteBuf>)Flux.from(input).map(bb -> {
            Object patt3725$temp = bb.asNativeBuffer();
            if (!(patt3725$temp instanceof ByteBuf)) {
                throw new IllegalArgumentException("Only netty buffers are supported");
            }
            ByteBuf buf = (ByteBuf)patt3725$temp;
            return buf;
        })).map(bb -> this.read(type, mediaType, httpHeaders, (ByteBuffer<?>)bb));
    }

    public boolean isReadable(Argument<T> type, MediaType mediaType) {
        return this.jsonMessageHandler.isReadable(type, mediaType);
    }

    public T read(Argument<T> type, MediaType mediaType, Headers httpHeaders, ByteBuffer<?> byteBuffer) throws CodecException {
        return (T)this.jsonMessageHandler.read(type, mediaType, httpHeaders, byteBuffer);
    }

    public T read(Argument<T> type, MediaType mediaType, Headers httpHeaders, InputStream inputStream) throws CodecException {
        return (T)this.jsonMessageHandler.read(type, mediaType, httpHeaders, inputStream);
    }

    public boolean isWriteable(Argument<T> type, MediaType mediaType) {
        return this.jsonMessageHandler.isWriteable(type, mediaType);
    }

    public void writeTo(Argument<T> type, MediaType mediaType, T object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
        this.jsonMessageHandler.writeTo(type, mediaType, object, outgoingHeaders, outputStream);
    }

    public ByteBuffer<?> writeTo(Argument<T> type, MediaType mediaType, T object, MutableHeaders outgoingHeaders, ByteBufferFactory<?, ?> bufferFactory) throws CodecException {
        return this.jsonMessageHandler.writeTo(type, mediaType, object, outgoingHeaders, bufferFactory);
    }

    public ByteBodyHttpResponse<?> write(@NonNull ByteBodyFactory bodyFactory, @NonNull HttpRequest<?> request, @NonNull MutableHttpResponse<T> outgoingResponse, @NonNull Argument<T> type, @NonNull MediaType mediaType, @NonNull T object) throws CodecException {
        return this.jsonMessageHandler.write(bodyFactory, request, outgoingResponse, type, mediaType, object);
    }

    public CloseableByteBody writePiece(@NonNull ByteBodyFactory bodyFactory, @NonNull HttpRequest<?> request, @NonNull HttpResponse<?> response, @NonNull Argument<T> type, @NonNull MediaType mediaType, T object) {
        return this.jsonMessageHandler.writePiece(bodyFactory, request, response, type, mediaType, object);
    }

    public MessageBodyWriter<T> createSpecific(Argument<T> type) {
        return new NettyJsonHandler<T>(this.jsonMessageHandler.createSpecific(type));
    }

    public boolean isBlocking() {
        return this.jsonMessageHandler.isBlocking();
    }
}

