/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.channel;

import io.micronaut.core.naming.Named;
import java.time.Duration;
import java.util.Optional;

public interface EventLoopGroupConfiguration
extends Named {
    public static final String EVENT_LOOPS = "micronaut.netty.event-loops";
    public static final String DEFAULT = "default";
    public static final String DEFAULT_LOOP = "micronaut.netty.event-loops.default";
    public static final double DEFAULT_THREAD_CORE_RATIO = 1.0;
    public static final long DEFAULT_SHUTDOWN_QUIET_PERIOD = 2L;
    public static final long DEFAULT_SHUTDOWN_TIMEOUT = 15L;

    public int getNumThreads();

    default public double getThreadCoreRatio() {
        return 1.0;
    }

    public Optional<Integer> getIoRatio();

    public Optional<String> getExecutorName();

    public boolean isPreferNativeTransport();

    default public Duration getShutdownQuietPeriod() {
        return Duration.ofSeconds(2L);
    }

    default public Duration getShutdownTimeout() {
        return Duration.ofSeconds(15L);
    }

    default public boolean isLoomCarrier() {
        return false;
    }
}

