/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.body;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.http.netty.body.JsonCounter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import java.io.IOException;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

@Internal
final class JsonChunkedProcessor {
    final JsonCounter counter = new JsonCounter();
    private ByteBuf singleBuffer;
    private CompositeByteBuf compositeBuffer;

    JsonChunkedProcessor() {
    }

    public Flux<ByteBuffer<?>> process(Flux<ByteBuf> input) {
        return Flux.concat((Publisher[])new Publisher[]{input.concatMap(b -> Flux.create(s -> {
            try {
                this.countLoop((FluxSink<? super ByteBuffer<?>>)s, (ByteBuf)b);
                s.complete();
            }
            catch (IOException e) {
                s.error((Throwable)e);
            }
            finally {
                b.release();
            }
        })), Flux.create(s -> {
            try {
                this.complete((FluxSink<? super ByteBuffer<?>>)s);
                s.complete();
            }
            catch (Throwable e) {
                s.error(e);
            }
        })}).doOnTerminate(this::releaseBuffers);
    }

    private void releaseBuffers() {
        if (this.singleBuffer != null) {
            this.singleBuffer.release();
            this.singleBuffer = null;
        }
        if (this.compositeBuffer != null) {
            this.compositeBuffer.release();
            this.compositeBuffer = null;
        }
    }

    private void countLoop(FluxSink<? super ByteBuffer<?>> out, ByteBuf content) throws IOException {
        long initialPosition = this.counter.position();
        long bias = initialPosition - (long)content.readerIndex();
        while (content.isReadable()) {
            this.counter.feed(content);
            JsonCounter.BufferRegion bufferRegion = this.counter.pollFlushedRegion();
            if (bufferRegion == null) continue;
            long start = Math.max(initialPosition, bufferRegion.start());
            this.buffer(content.retainedSlice(Math.toIntExact(start - bias), Math.toIntExact(bufferRegion.end() - start)));
            this.flush(out);
        }
        if (this.counter.isBuffering()) {
            int currentBufferStart = Math.toIntExact(Math.max(initialPosition, this.counter.bufferStart()) - bias);
            content.readerIndex(currentBufferStart);
            this.buffer(content.retain());
        }
    }

    private void buffer(ByteBuf buffer) {
        if (this.singleBuffer == null && this.compositeBuffer == null) {
            this.singleBuffer = buffer;
        } else {
            if (this.compositeBuffer == null) {
                this.compositeBuffer = buffer.alloc().compositeBuffer();
                this.compositeBuffer.addComponent(true, this.singleBuffer);
                this.singleBuffer = null;
            }
            this.compositeBuffer.addComponent(true, buffer);
        }
    }

    private void flush(FluxSink<? super ByteBuffer<?>> out) {
        ByteBuf completedNode = this.compositeBuffer == null ? this.singleBuffer : this.compositeBuffer;
        ByteBuffer wrapped = NettyByteBufferFactory.DEFAULT.wrap(completedNode);
        out.next((Object)wrapped);
        this.compositeBuffer = null;
        this.singleBuffer = null;
    }

    private void complete(FluxSink<? super ByteBuffer<?>> out) {
        if (this.singleBuffer != null || this.compositeBuffer != null) {
            this.flush(out);
        }
    }
}

