/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.body;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.Writable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.ByteBodyHttpResponse;
import io.micronaut.http.ByteBodyHttpResponseWrapper;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.body.ByteBodyFactory;
import io.micronaut.http.body.ChunkedMessageBodyReader;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.body.ResponseBodyWriter;
import io.micronaut.http.body.TypedMessageBodyHandler;
import io.micronaut.http.body.WritableBodyWriter;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.exceptions.MessageBodyException;
import io.micronaut.http.netty.body.AvailableNettyByteBody;
import io.micronaut.runtime.ApplicationConfiguration;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.reactivestreams.Publisher;

@Replaces(value=WritableBodyWriter.class)
@Singleton
@Internal
@BootstrapContextCompatible
public final class NettyWritableBodyWriter
implements TypedMessageBodyHandler<Writable>,
ChunkedMessageBodyReader<Writable>,
ResponseBodyWriter<Writable> {
    private final WritableBodyWriter defaultWritable;

    public NettyWritableBodyWriter(ApplicationConfiguration applicationConfiguration) {
        this.defaultWritable = new WritableBodyWriter(applicationConfiguration);
    }

    public Argument<Writable> getType() {
        return Argument.of(Writable.class);
    }

    public boolean isBlocking() {
        return true;
    }

    public ByteBodyHttpResponse<?> write(@NonNull ByteBodyFactory bodyFactory, HttpRequest<?> request, MutableHttpResponse<Writable> outgoingResponse, Argument<Writable> type, MediaType mediaType, Writable object) throws CodecException {
        outgoingResponse.getHeaders().contentTypeIfMissing(mediaType);
        return ByteBodyHttpResponseWrapper.wrap(outgoingResponse, (CloseableByteBody)this.writePiece(bodyFactory, request, (HttpResponse<?>)outgoingResponse, type, mediaType, object));
    }

    public CloseableByteBody writePiece(@NonNull ByteBodyFactory bodyFactory, @NonNull HttpRequest<?> request, @NonNull HttpResponse<?> response, @NonNull Argument<Writable> type, @NonNull MediaType mediaType, Writable object) {
        ByteBufOutputStream outputStream = new ByteBufOutputStream(ByteBufAllocator.DEFAULT.buffer());
        try {
            object.writeTo((OutputStream)outputStream, MessageBodyWriter.getCharset((MediaType)mediaType, (Headers)response.getHeaders()));
            outputStream.close();
        }
        catch (IOException e) {
            throw new MessageBodyException("Error writing body from writable", (Throwable)e);
        }
        return new AvailableNettyByteBody(outputStream.buffer());
    }

    public void writeTo(Argument<Writable> type, MediaType mediaType, Writable object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
        this.defaultWritable.writeTo(type, mediaType, object, outgoingHeaders, outputStream);
    }

    public Publisher<? extends Writable> readChunked(Argument<Writable> type, MediaType mediaType, Headers httpHeaders, Publisher<ByteBuffer<?>> input) {
        return this.defaultWritable.readChunked(type, mediaType, httpHeaders, input);
    }

    public Writable read(Argument<Writable> type, MediaType mediaType, Headers httpHeaders, InputStream inputStream) throws CodecException {
        return this.defaultWritable.read(type, mediaType, httpHeaders, inputStream);
    }
}

