/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.channel;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Factory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.http.netty.configuration.NettyGlobalConfiguration;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.FastThreadLocalThread;
import io.netty.util.internal.SystemPropertyUtil;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import reactor.core.scheduler.NonBlocking;

@Singleton
@Factory
@TypeHint(value={NioServerSocketChannel.class, NioSocketChannel.class}, typeNames={"sun.security.ssl.SSLContextImpl$TLSContext"}, accessType={TypeHint.AccessType.ALL_DECLARED_CONSTRUCTORS, TypeHint.AccessType.ALL_DECLARED_FIELDS, TypeHint.AccessType.ALL_PUBLIC_CONSTRUCTORS})
@BootstrapContextCompatible
public class NettyThreadFactory {
    public static final String NAME = "netty";
    @Deprecated(forRemoval=true, since="4.2.0")
    public static final int DEFAULT_EVENT_LOOP_THREADS = 1;
    private final NettyGlobalConfiguration configuration;

    @Inject
    public NettyThreadFactory(NettyGlobalConfiguration configuration) {
        this.configuration = configuration;
    }

    @Deprecated
    public NettyThreadFactory() {
        this(new NettyGlobalConfiguration());
    }

    @Deprecated(forRemoval=true)
    public static int getDefaultEventLoopThreads() {
        return Math.max(1, SystemPropertyUtil.getInt((String)"io.netty.eventLoopThreads", (int)(NettyRuntime.availableProcessors() * 2)));
    }

    @Singleton
    @Named(value="netty")
    @BootstrapContextCompatible
    protected ThreadFactory nettyThreadFactory() {
        return new EventLoopCustomizableThreadFactory(this.configuration.isDefaultThreadFactoryDaemon(), this.configuration.getDefaultThreadFactoryPriority(), this.configuration.isDefaultThreadFactoryReactorNonBlocking());
    }

    @Internal
    public static final class EventLoopCustomizableThreadFactory
    implements ThreadFactory {
        private final boolean daemon;
        private final int priority;
        private final boolean nonBlocking;
        private final Supplier<ThreadFactory> fallbackDelegate = SupplierUtil.memoized(this::customizeForEventLoop);

        public EventLoopCustomizableThreadFactory(boolean daemon, int priority, boolean nonBlocking) {
            this.daemon = daemon;
            this.priority = priority;
            this.nonBlocking = nonBlocking;
        }

        public ThreadFactory customizeForEventLoop() {
            return new CustomizedThreadFactory(this.daemon, this.priority, this.nonBlocking);
        }

        @Override
        public Thread newThread(Runnable r) {
            return this.fallbackDelegate.get().newThread(r);
        }
    }

    private static final class NonBlockingFastThreadLocalThread
    extends FastThreadLocalThread
    implements NonBlocking {
        public NonBlockingFastThreadLocalThread(ThreadGroup group, Runnable target, String name) {
            super(group, target, name);
        }
    }

    private static final class CustomizedThreadFactory
    extends DefaultThreadFactory {
        private final boolean nonBlocking;

        public CustomizedThreadFactory(boolean daemon, int priority, boolean nonBlocking) {
            super("default-eventLoopGroup", daemon, priority);
            this.nonBlocking = nonBlocking;
        }

        protected Thread newThread(Runnable r, String name) {
            if (this.nonBlocking) {
                return new NonBlockingFastThreadLocalThread(this.threadGroup, r, name);
            }
            return super.newThread(r, name);
        }
    }
}

