/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty;

import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.ssl.ClientAuthentication;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.codec.http3.Http3;
import io.netty.handler.codec.quic.QuicSslContext;
import io.netty.handler.codec.quic.QuicSslContextBuilder;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.OpenSslCachingX509KeyManagerFactory;
import io.netty.handler.ssl.OpenSslX509KeyManagerFactory;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.security.KeyStore;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public class NettySslContextBuilder {
    private final boolean server;
    @Nullable
    private KeyStore keyStore;
    @Nullable
    private String keyPassword;
    @Nullable
    private KeyStore trustStore;
    private boolean trustAll;
    private boolean openssl = false;
    @Nullable
    private List<String> protocols;
    @Nullable
    private List<String> ciphers;
    private boolean ignoreUnsupportedCiphers = false;
    @Nullable
    private List<String> alpnProtocols;
    @Nullable
    private ClientAuthentication clientAuthentication;

    public NettySslContextBuilder(boolean server) {
        this.server = server;
    }

    @NonNull
    public final NettySslContextBuilder openssl(boolean openssl) {
        this.openssl = openssl;
        return this;
    }

    protected final boolean openssl() {
        return this.openssl;
    }

    @Nullable
    protected final KeyStore keyStore() {
        return this.keyStore;
    }

    @NonNull
    public final NettySslContextBuilder keyStore(@Nullable KeyStore keyStore) {
        this.keyStore = keyStore;
        return this;
    }

    @Nullable
    protected final String keyPassword() {
        return this.keyPassword;
    }

    @NonNull
    public final NettySslContextBuilder keyPassword(@Nullable String keyPassword) {
        this.keyPassword = keyPassword;
        return this;
    }

    @Nullable
    protected final KeyStore trustStore() {
        return this.trustStore;
    }

    @NonNull
    public final NettySslContextBuilder trustStore(@Nullable KeyStore trustStore) {
        this.trustStore = trustStore;
        return this;
    }

    protected final boolean trustAll() {
        return this.trustAll;
    }

    @NonNull
    public final NettySslContextBuilder trustAll(boolean trustAll) {
        this.trustAll = trustAll;
        return this;
    }

    @Nullable
    protected final List<String> protocols() {
        return this.protocols;
    }

    @NonNull
    public final NettySslContextBuilder protocols(@Nullable List<String> protocols) {
        this.protocols = protocols;
        return this;
    }

    @Nullable
    protected final List<String> ciphers() {
        return this.ciphers;
    }

    @NonNull
    public final NettySslContextBuilder ciphers(@Nullable List<String> ciphers, boolean ignoreUnsupportedCiphers) {
        this.ciphers = ciphers;
        this.ignoreUnsupportedCiphers = ignoreUnsupportedCiphers;
        return this;
    }

    @Nullable
    protected final List<String> alpnProtocols() {
        return this.alpnProtocols;
    }

    @NonNull
    public final NettySslContextBuilder alpnProtocols(@Nullable List<String> alpnProtocols) {
        this.alpnProtocols = alpnProtocols;
        return this;
    }

    @NonNull
    public final NettySslContextBuilder http2() {
        if (this.ciphers == null) {
            this.ciphers(Http2SecurityUtil.CIPHERS, true);
        }
        if (this.alpnProtocols == null) {
            this.alpnProtocols(List.of("h2", "http/1.1"));
        }
        return this;
    }

    @Nullable
    protected final ClientAuthentication clientAuthentication() {
        return this.clientAuthentication;
    }

    @NonNull
    public final NettySslContextBuilder clientAuthentication(@Nullable ClientAuthentication clientAuthentication) {
        this.clientAuthentication = clientAuthentication;
        return this;
    }

    @NonNull
    protected TrustManagerFactory createTrustManagerFactory() throws Exception {
        if (this.trustAll) {
            if (this.trustStore != null) {
                throw new ConfigurationException("If you want to trust all certificates, please don't also specify a trust store");
            }
            return InsecureTrustManagerFactory.INSTANCE;
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(this.trustStore);
        return trustManagerFactory;
    }

    @NonNull
    protected KeyManagerFactory createKeyManagerFactory() throws Exception {
        Object keyManagerFactory = this.openssl && this.keyStore != null ? (this.keyStore.aliases().hasMoreElements() ? new OpenSslX509KeyManagerFactory() : new OpenSslCachingX509KeyManagerFactory(KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm()))) : KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        ((KeyManagerFactory)keyManagerFactory).init(this.keyStore, this.keyPassword == null ? null : this.keyPassword.toCharArray());
        return keyManagerFactory;
    }

    @NonNull
    public SslContext buildTcp() throws Exception {
        SslContextBuilder sslBuilder = this.server ? SslContextBuilder.forServer((KeyManagerFactory)this.createKeyManagerFactory()) : SslContextBuilder.forClient().keyManager(this.createKeyManagerFactory());
        sslBuilder.trustManager(this.createTrustManagerFactory());
        sslBuilder.sslProvider(this.openssl ? SslProvider.OPENSSL_REFCNT : SslProvider.JDK);
        if (this.protocols != null) {
            sslBuilder.protocols(this.protocols);
        }
        if (this.ciphers != null) {
            sslBuilder.ciphers(this.ciphers, (CipherSuiteFilter)(this.ignoreUnsupportedCiphers ? SupportedCipherSuiteFilter.INSTANCE : IdentityCipherSuiteFilter.INSTANCE));
        }
        if (this.clientAuthentication == ClientAuthentication.NEED) {
            sslBuilder.clientAuth(ClientAuth.REQUIRE);
        } else if (this.clientAuthentication == ClientAuthentication.WANT) {
            sslBuilder.clientAuth(ClientAuth.OPTIONAL);
        }
        if (this.alpnProtocols != null) {
            sslBuilder.applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, this.alpnProtocols));
        }
        return sslBuilder.build();
    }

    @NonNull
    public QuicSslContext buildHttp3() throws Exception {
        QuicSslContextBuilder sslBuilder = this.server ? QuicSslContextBuilder.forServer((KeyManagerFactory)this.createKeyManagerFactory(), (String)this.keyPassword) : QuicSslContextBuilder.forClient().keyManager(this.createKeyManagerFactory(), this.keyPassword);
        sslBuilder.trustManager(this.createTrustManagerFactory());
        sslBuilder.applicationProtocols(Http3.supportedApplicationProtocols());
        if (this.clientAuthentication == ClientAuthentication.NEED) {
            sslBuilder.clientAuth(ClientAuth.REQUIRE);
        } else if (this.clientAuthentication == ClientAuthentication.WANT) {
            sslBuilder.clientAuth(ClientAuth.OPTIONAL);
        }
        return sslBuilder.build();
    }
}

