/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.jdk;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.DelayedSubscriber;
import io.micronaut.core.io.buffer.ByteArrayBufferFactory;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.io.buffer.ReadBuffer;
import io.micronaut.http.body.ByteBodyFactory;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.stream.BodySizeLimits;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import org.reactivestreams.Subscription;

@Internal
final class ByteBodySubscriber
implements HttpResponse.BodySubscriber<CloseableByteBody> {
    private static final ByteBodyFactory BODY_FACTORY = ByteBodyFactory.createDefault((ByteBufferFactory)ByteArrayBufferFactory.INSTANCE);
    private final DelayedSubscriber<ReadBuffer> defer = new DelayedSubscriber();
    private final CloseableByteBody mapped;

    public ByteBodySubscriber(BodySizeLimits limits) {
        this.mapped = BODY_FACTORY.adapt(this.defer, limits, null, null);
    }

    @Override
    public CompletionStage<CloseableByteBody> getBody() {
        return CompletableFuture.completedFuture(this.mapped);
    }

    @Override
    public void onSubscribe(final Flow.Subscription subscription) {
        this.defer.onSubscribe(new Subscription(){

            public void request(long n) {
                subscription.request(n);
            }

            public void cancel() {
                subscription.cancel();
            }
        });
    }

    @Override
    public void onNext(List<ByteBuffer> item) {
        if (item.isEmpty()) {
            this.defer.onNext((Object)BODY_FACTORY.readBufferFactory().createEmpty());
        } else if (item.size() == 1) {
            this.defer.onNext((Object)BODY_FACTORY.readBufferFactory().adapt(item.get(0)));
        } else {
            ArrayList<ReadBuffer> buffers = new ArrayList<ReadBuffer>(item.size());
            for (ByteBuffer byteBuffer : item) {
                buffers.add(BODY_FACTORY.readBufferFactory().adapt(byteBuffer));
            }
            this.defer.onNext((Object)BODY_FACTORY.readBufferFactory().compose(buffers));
        }
    }

    @Override
    public void onError(Throwable throwable) {
        this.defer.onError(throwable);
    }

    @Override
    public void onComplete() {
        this.defer.onComplete();
    }
}

