/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.jdk;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.http.ByteBodyHttpResponseWrapper;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.stream.BodySizeLimits;
import io.micronaut.http.client.RawHttpClient;
import io.micronaut.http.client.exceptions.HttpClientException;
import io.micronaut.http.client.jdk.AbstractJdkHttpClient;
import io.micronaut.http.client.jdk.BaseHttpResponseAdapter;
import io.micronaut.http.client.jdk.ByteBodySubscriber;
import io.micronaut.http.client.jdk.RawHttpRequestWrapper;
import io.micronaut.http.util.HttpHeadersUtil;
import java.io.IOException;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import reactor.core.publisher.Mono;

@Internal
final class JdkRawHttpClient
extends AbstractJdkHttpClient
implements RawHttpClient {
    public JdkRawHttpClient(AbstractJdkHttpClient prototype) {
        super(prototype);
    }

    @NonNull
    public Publisher<? extends HttpResponse<?>> exchange(@NonNull HttpRequest<?> request, @Nullable CloseableByteBody requestBody, @Nullable Thread blockedThread) {
        return this.exchangeImpl(new RawHttpRequestWrapper(this.conversionService, request.toMutableRequest(), requestBody), null);
    }

    public void close() throws IOException {
    }

    @Override
    protected <O> Publisher<HttpResponse<O>> responsePublisher(@NonNull HttpRequest<?> request, @Nullable Argument<O> bodyType) {
        return Mono.defer(() -> this.mapToHttpRequest(request, bodyType)).map(httpRequest -> {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Client {} Sending HTTP Request: {}", (Object)this.clientId, httpRequest);
            }
            if (this.log.isTraceEnabled()) {
                HttpHeadersUtil.trace((Logger)this.log, () -> httpRequest.headers().map().keySet(), headerName -> httpRequest.headers().allValues((String)headerName));
            }
            BodySizeLimits bodySizeLimits = new BodySizeLimits(Long.MAX_VALUE, (long)this.configuration.getMaxContentLength());
            return this.client.sendAsync((java.net.http.HttpRequest)httpRequest, responseInfo -> new ByteBodySubscriber(bodySizeLimits));
        }).flatMap(Mono::fromCompletionStage).onErrorMap(IOException.class, e -> new HttpClientException("Error sending request: " + e.getMessage(), (Throwable)e)).onErrorMap(InterruptedException.class, e -> new HttpClientException("Error sending request: " + e.getMessage(), (Throwable)e)).map(netResponse -> {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Client {} Received HTTP Response: {} {}", new Object[]{this.clientId, netResponse.statusCode(), netResponse.uri()});
            }
            return ByteBodyHttpResponseWrapper.wrap((HttpResponse)new BaseHttpResponseAdapter<CloseableByteBody, O>((java.net.http.HttpResponse)netResponse, this.conversionService){

                @NonNull
                public Optional<O> getBody() {
                    return Optional.empty();
                }
            }, (CloseableByteBody)((CloseableByteBody)netResponse.body()));
        });
    }
}

