/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.jdk;

import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Primary;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.FilterMatcher;
import io.micronaut.http.bind.DefaultRequestBinderRegistry;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.bind.binders.RequestArgumentBinder;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.body.MessageBodyReader;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.HttpClientRegistry;
import io.micronaut.http.client.HttpVersionSelection;
import io.micronaut.http.client.LoadBalancer;
import io.micronaut.http.client.LoadBalancerResolver;
import io.micronaut.http.client.RawHttpClient;
import io.micronaut.http.client.RawHttpClientRegistry;
import io.micronaut.http.client.annotation.Client;
import io.micronaut.http.client.exceptions.HttpClientException;
import io.micronaut.http.client.filter.ClientFilterResolutionContext;
import io.micronaut.http.client.jdk.DefaultJdkHttpClient;
import io.micronaut.http.client.jdk.JdkClientSslBuilder;
import io.micronaut.http.client.jdk.JdkRawHttpClient;
import io.micronaut.http.client.jdk.cookie.CompositeCookieDecoder;
import io.micronaut.http.client.jdk.cookie.CookieDecoder;
import io.micronaut.http.client.jdk.cookie.DefaultCookieDecoder;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.filter.HttpClientFilterResolver;
import io.micronaut.inject.InjectionPoint;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.json.JsonFeatures;
import io.micronaut.json.JsonMapper;
import io.micronaut.json.body.CustomizableJsonHandler;
import io.micronaut.json.codec.MapperMediaTypeCodec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
@BootstrapContextCompatible
@Order(value=2)
@Internal
public final class DefaultJdkHttpClientRegistry
implements AutoCloseable,
HttpClientRegistry<HttpClient>,
RawHttpClientRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJdkHttpClientRegistry.class);
    private final Map<ClientKey, DefaultJdkHttpClient> clients = new ConcurrentHashMap<ClientKey, DefaultJdkHttpClient>(10);
    private final BeanContext beanContext;
    private final LoadBalancerResolver loadBalancerResolver;
    private final HttpClientConfiguration defaultHttpClientConfiguration;
    private final JsonMapper jsonMapper;
    @Nullable
    private final MediaTypeCodecRegistry mediaTypeCodecRegistry;
    private final MessageBodyHandlerRegistry messageBodyHandlerRegistry;
    private final BeanProvider<RequestBinderRegistry> requestBinderRegistryProvider;
    private final JdkClientSslBuilder jdkClientSslBuilder;
    private final CookieDecoder cookieDecoder;
    private final HttpClientFilterResolver<ClientFilterResolutionContext> clientFilterResolver;

    public DefaultJdkHttpClientRegistry(BeanContext beanContext, LoadBalancerResolver loadBalancerResolver, HttpClientConfiguration defaultHttpClientConfiguration, HttpClientFilterResolver<ClientFilterResolutionContext> httpClientFilterResolver, JsonMapper jsonMapper, @Nullable MediaTypeCodecRegistry mediaTypeCodecRegistry, MessageBodyHandlerRegistry messageBodyHandlerRegistry, BeanProvider<RequestBinderRegistry> requestBinderRegistryProvider, BeanProvider<JdkClientSslBuilder> sslBuilderBeanProvider, BeanProvider<CookieDecoder> cookieDecoderBeanProvider) {
        this.beanContext = beanContext;
        this.loadBalancerResolver = loadBalancerResolver;
        this.defaultHttpClientConfiguration = defaultHttpClientConfiguration;
        this.clientFilterResolver = httpClientFilterResolver;
        this.jsonMapper = jsonMapper;
        this.mediaTypeCodecRegistry = mediaTypeCodecRegistry;
        this.messageBodyHandlerRegistry = messageBodyHandlerRegistry;
        this.requestBinderRegistryProvider = requestBinderRegistryProvider;
        this.jdkClientSslBuilder = (JdkClientSslBuilder)((Object)sslBuilderBeanProvider.orElse((Object)new JdkClientSslBuilder(new ResourceResolver())));
        this.cookieDecoder = (CookieDecoder)cookieDecoderBeanProvider.orElse((Object)new CompositeCookieDecoder(List.of(new DefaultCookieDecoder())));
    }

    private static MediaTypeCodec createNewJsonCodec(BeanContext beanContext, JsonFeatures jsonFeatures) {
        return DefaultJdkHttpClientRegistry.getJsonCodec(beanContext).cloneWithFeatures(jsonFeatures);
    }

    private static MapperMediaTypeCodec getJsonCodec(BeanContext beanContext) {
        return (MapperMediaTypeCodec)beanContext.getBean(MapperMediaTypeCodec.class, Qualifiers.byName((String)"json"));
    }

    @Bean
    @BootstrapContextCompatible
    @Primary
    @Order(value=2)
    protected DefaultJdkHttpClient httpClient(@Nullable InjectionPoint<?> injectionPoint, @Parameter @Nullable LoadBalancer loadBalancer, @Parameter @Nullable HttpClientConfiguration configuration, BeanContext beanContext) {
        return this.resolveDefaultHttpClient(injectionPoint, loadBalancer, configuration, beanContext);
    }

    @Bean
    @BootstrapContextCompatible
    @Primary
    @Order(value=2)
    RawHttpClient rawHttpClient(@Nullable InjectionPoint<?> injectionPoint, @Parameter @Nullable LoadBalancer loadBalancer, @Parameter @Nullable HttpClientConfiguration configuration, BeanContext beanContext) {
        return new JdkRawHttpClient(this.resolveDefaultHttpClient(injectionPoint, loadBalancer, configuration, beanContext));
    }

    private DefaultJdkHttpClient resolveDefaultHttpClient(@Nullable InjectionPoint<?> injectionPoint, @Nullable LoadBalancer loadBalancer, @Nullable HttpClientConfiguration configuration, BeanContext beanContext) {
        if (loadBalancer != null) {
            if (configuration == null) {
                configuration = this.defaultHttpClientConfiguration;
            }
            return this.buildClient(loadBalancer, null, configuration, null, loadBalancer.getContextPath().orElse(null), beanContext, AnnotationMetadata.EMPTY_METADATA);
        }
        return this.getClient(injectionPoint != null ? injectionPoint.getAnnotationMetadata() : AnnotationMetadata.EMPTY_METADATA);
    }

    public DefaultJdkHttpClient getClient(AnnotationMetadata annotationMetadata) {
        ClientKey key = this.getClientKey(annotationMetadata);
        return this.getClient(key, annotationMetadata);
    }

    private ClientKey getClientKey(AnnotationMetadata metadata) {
        HttpVersionSelection httpVersionSelection = HttpVersionSelection.forClientAnnotation((AnnotationMetadata)metadata);
        String clientId = metadata.stringValue(Client.class).orElse(null);
        String path = metadata.stringValue(Client.class, "path").orElse(null);
        List filterAnnotation = metadata.getAnnotationNamesByStereotype(FilterMatcher.class);
        Class configurationClass = metadata.classValue(Client.class, "configuration").orElse(null);
        JsonFeatures jsonFeatures = this.jsonMapper.detectFeatures(metadata).orElse(null);
        return new ClientKey(httpVersionSelection, clientId, filterAnnotation, path, configurationClass, jsonFeatures);
    }

    private DefaultJdkHttpClient getClient(ClientKey key, AnnotationMetadata annotationMetadata) {
        return this.clients.computeIfAbsent(key, clientKey -> {
            DefaultJdkHttpClient clientBean = null;
            String clientId = clientKey.clientId;
            Class<?> configurationClass = clientKey.configurationClass;
            if (clientId != null) {
                clientBean = this.beanContext.findBean(HttpClient.class, Qualifiers.byName((String)clientId)).orElse(null);
            }
            if (configurationClass != null && !HttpClientConfiguration.class.isAssignableFrom(configurationClass)) {
                throw new IllegalStateException("Referenced HTTP client configuration class must be an instance of HttpClientConfiguration for injection point: " + String.valueOf(configurationClass));
            }
            List<String> filterAnnotations = clientKey.filterAnnotations;
            String path = clientKey.path;
            if (clientBean != null && path == null && configurationClass == null && filterAnnotations.isEmpty()) {
                return clientBean;
            }
            LoadBalancer loadBalancer = null;
            HttpClientConfiguration configuration = configurationClass != null ? (HttpClientConfiguration)this.beanContext.getBean(configurationClass) : (clientId != null ? this.beanContext.findBean(HttpClientConfiguration.class, Qualifiers.byName((String)clientId)).orElse(this.defaultHttpClientConfiguration) : this.defaultHttpClientConfiguration);
            if (clientId != null) {
                loadBalancer = (LoadBalancer)this.loadBalancerResolver.resolve(new String[]{clientId}).orElseThrow(() -> new HttpClientException("Invalid service reference [" + clientId + "] specified to @Client"));
            }
            String contextPath = null;
            if (StringUtils.isNotEmpty((CharSequence)path)) {
                contextPath = path;
            } else if (StringUtils.isNotEmpty((CharSequence)clientId) && clientId.startsWith("/")) {
                contextPath = clientId;
            } else if (loadBalancer != null) {
                contextPath = loadBalancer.getContextPath().orElse(null);
            }
            final DefaultJdkHttpClient client = this.buildClient(loadBalancer, clientKey.httpVersion, configuration, clientId, contextPath, this.beanContext, annotationMetadata);
            final JsonFeatures jsonFeatures = clientKey.jsonFeatures;
            if (jsonFeatures != null) {
                ArrayList<Object> codecs = new ArrayList<Object>(2);
                MediaTypeCodecRegistry codecRegistry = client.getMediaTypeCodecRegistry();
                for (MediaTypeCodec codec : codecRegistry.getCodecs()) {
                    if (codec instanceof MapperMediaTypeCodec) {
                        MapperMediaTypeCodec mapper = (MapperMediaTypeCodec)codec;
                        codecs.add(mapper.cloneWithFeatures(jsonFeatures));
                        continue;
                    }
                    codecs.add(codec);
                }
                if (codecRegistry.findCodec(MediaType.APPLICATION_JSON_TYPE).isEmpty()) {
                    codecs.add(DefaultJdkHttpClientRegistry.createNewJsonCodec(this.beanContext, jsonFeatures));
                }
                client.setMediaTypeCodecRegistry(MediaTypeCodecRegistry.of(codecs));
                client.setMessageBodyHandlerRegistry(new MessageBodyHandlerRegistry(){
                    final MessageBodyHandlerRegistry delegate;
                    {
                        this.delegate = client.getMessageBodyHandlerRegistry();
                    }

                    private <T> T customize(T handler) {
                        if (handler instanceof CustomizableJsonHandler) {
                            CustomizableJsonHandler cnjh = (CustomizableJsonHandler)handler;
                            return (T)cnjh.customize(jsonFeatures);
                        }
                        return handler;
                    }

                    public <T> Optional<MessageBodyReader<T>> findReader(Argument<T> type, List<MediaType> mediaType) {
                        return this.delegate.findReader(type, mediaType).map(this::customize);
                    }

                    public <T> Optional<MessageBodyWriter<T>> findWriter(Argument<T> type, List<MediaType> mediaType) {
                        return this.delegate.findWriter(type, mediaType).map(this::customize);
                    }
                });
            }
            return client;
        });
    }

    private DefaultJdkHttpClient buildClient(LoadBalancer loadBalancer, HttpVersionSelection httpVersion, HttpClientConfiguration configuration, String clientId, String contextPath, BeanContext beanContext, AnnotationMetadata annotationMetadata) {
        ConversionService conversionService = (ConversionService)beanContext.getBean(ConversionService.class);
        return new DefaultJdkHttpClient(loadBalancer, httpVersion, configuration, contextPath, this.clientFilterResolver, this.clientFilterResolver.resolveFilterEntries((AnnotationMetadataProvider)new ClientFilterResolutionContext(clientId == null ? null : Collections.singletonList(clientId), annotationMetadata)), this.mediaTypeCodecRegistry, this.messageBodyHandlerRegistry, (RequestBinderRegistry)this.requestBinderRegistryProvider.orElse((Object)new DefaultRequestBinderRegistry(conversionService, new RequestArgumentBinder[0])), clientId, conversionService, this.jdkClientSslBuilder, this.cookieDecoder);
    }

    public DefaultJdkHttpClient getClient(HttpVersionSelection httpVersion, String clientId, String path) {
        ClientKey key = new ClientKey(httpVersion, clientId, null, path, null, null);
        return this.getClient(key, AnnotationMetadata.EMPTY_METADATA);
    }

    public HttpClient resolveClient(InjectionPoint<?> injectionPoint, LoadBalancer loadBalancer, HttpClientConfiguration configuration, BeanContext beanContext) {
        return this.resolveDefaultHttpClient(injectionPoint, loadBalancer, configuration, beanContext);
    }

    public void disposeClient(AnnotationMetadata annotationMetadata) {
        ClientKey key = this.getClientKey(annotationMetadata);
        HttpClient client = this.clients.remove(key);
        if (client != null && client.isRunning()) {
            client.close();
        }
    }

    @Override
    public void close() throws Exception {
        for (HttpClient httpClient : this.clients.values()) {
            try {
                httpClient.close();
            }
            catch (Throwable e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("Error shutting down HTTP client: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        this.clients.clear();
    }

    @NonNull
    public RawHttpClient getRawClient(@NonNull HttpVersionSelection httpVersion, @NonNull String clientId, @Nullable String path) {
        return new JdkRawHttpClient(this.getClient(httpVersion, clientId, path));
    }

    @Internal
    private record ClientKey(HttpVersionSelection httpVersion, String clientId, List<String> filterAnnotations, String path, Class<?> configurationClass, JsonFeatures jsonFeatures) {
    }
}

