/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.jdk;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.client.jdk.HttpHeadersAdapter;

@Internal
abstract class BaseHttpResponseAdapter<B, O>
implements HttpResponse<O> {
    final java.net.http.HttpResponse<B> httpResponse;
    final ConversionService conversionService;
    final MutableConvertibleValues<Object> attributes = new MutableConvertibleValuesMap();

    BaseHttpResponseAdapter(java.net.http.HttpResponse<B> httpResponse, ConversionService conversionService) {
        this.httpResponse = httpResponse;
        this.conversionService = conversionService;
    }

    public HttpStatus getStatus() {
        return HttpStatus.valueOf((int)this.httpResponse.statusCode());
    }

    public int code() {
        return this.httpResponse.statusCode();
    }

    public String reason() {
        return this.getStatus().getReason();
    }

    public HttpHeaders getHeaders() {
        return new HttpHeadersAdapter(this.httpResponse.headers(), this.conversionService);
    }

    public MutableConvertibleValues<Object> getAttributes() {
        return this.attributes;
    }
}

