/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.jdk.cookie;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.client.jdk.cookie.CookieDecoder;
import io.micronaut.http.client.netty.NettyClientHttpRequest;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.http.simple.cookies.SimpleCookie;
import io.micronaut.http.simple.cookies.SimpleCookies;
import jakarta.inject.Singleton;
import java.net.HttpCookie;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

@Singleton
@Internal
@Requires(classes={NettyClientHttpRequest.class})
public class NettyCookieDecoder
implements CookieDecoder {
    public static final int ORDER = 1;
    private final ConversionService conversionService;

    public NettyCookieDecoder(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    @NonNull
    public Optional<Cookies> decode(HttpRequest<?> request) {
        if (request instanceof NettyClientHttpRequest) {
            NettyClientHttpRequest nettyClientHttpRequest = (NettyClientHttpRequest)request;
            SimpleCookies entries = new SimpleCookies(this.conversionService);
            List headerCookies = nettyClientHttpRequest.getHeaders().getAll((CharSequence)"Cookie").stream().map(HttpCookie::parse).flatMap(Collection::stream).toList();
            headerCookies.forEach(cookie -> {
                SimpleCookie c = new SimpleCookie(cookie.getName(), cookie.getValue());
                c.maxAge(cookie.getMaxAge());
                c.domain(cookie.getDomain());
                c.httpOnly(cookie.isHttpOnly());
                c.path(cookie.getPath());
                c.secure(cookie.getSecure());
                entries.put((CharSequence)cookie.getName(), (Cookie)c);
            });
            return Optional.of(entries);
        }
        return Optional.empty();
    }

    public int getOrder() {
        return 1;
    }
}

