/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.jdk;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.buffer.ByteArrayBufferFactory;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.ContextlessMessageBodyHandlerRegistry;
import io.micronaut.http.body.MessageBodyHandler;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.body.TypedMessageBodyHandler;
import io.micronaut.http.body.WritableBodyWriter;
import io.micronaut.http.client.AbstractHttpClientFactory;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.jdk.DefaultJdkHttpClient;
import io.micronaut.json.JsonMapper;
import io.micronaut.json.body.JsonMessageHandler;
import io.micronaut.runtime.ApplicationConfiguration;
import java.net.URI;

@Internal
public class JdkHttpClientFactory
extends AbstractHttpClientFactory<DefaultJdkHttpClient> {
    public JdkHttpClientFactory() {
        super(null, JdkHttpClientFactory.createDefaultMessageBodyHandlerRegistry(), ConversionService.SHARED);
    }

    protected DefaultJdkHttpClient createHttpClient(URI uri) {
        return new DefaultJdkHttpClient(uri, this.conversionService);
    }

    protected DefaultJdkHttpClient createHttpClient(URI uri, HttpClientConfiguration configuration) {
        return new DefaultJdkHttpClient(uri, configuration, this.mediaTypeCodecRegistry, this.messageBodyHandlerRegistry, this.conversionService);
    }

    public static MessageBodyHandlerRegistry createDefaultMessageBodyHandlerRegistry() {
        ApplicationConfiguration applicationConfiguration = new ApplicationConfiguration();
        ContextlessMessageBodyHandlerRegistry registry = new ContextlessMessageBodyHandlerRegistry(applicationConfiguration, (ByteBufferFactory)ByteArrayBufferFactory.INSTANCE, new TypedMessageBodyHandler[]{new WritableBodyWriter(applicationConfiguration)});
        JsonMapper mapper = JsonMapper.createDefault();
        registry.add(MediaType.APPLICATION_JSON_TYPE, (MessageBodyHandler)new JsonMessageHandler(mapper));
        registry.add(MediaType.APPLICATION_JSON_STREAM_TYPE, (MessageBodyHandler)new JsonMessageHandler(mapper));
        return registry;
    }
}

