/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.jdk;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.io.buffer.ByteArrayBufferFactory;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.body.MessageBodyReader;
import io.micronaut.http.client.jdk.HttpHeadersAdapter;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class HttpResponseAdapter<O>
implements HttpResponse<O> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpResponseAdapter.class);
    private final java.net.http.HttpResponse<byte[]> httpResponse;
    @NonNull
    private final Argument<O> bodyType;
    private final ConversionService conversionService;
    private final MutableConvertibleValues<Object> attributes = new MutableConvertibleValuesMap();
    private final MediaTypeCodecRegistry mediaTypeCodecRegistry;
    private final MessageBodyHandlerRegistry messageBodyHandlerRegistry;

    public HttpResponseAdapter(java.net.http.HttpResponse<byte[]> httpResponse, @Nullable Argument<O> bodyType, ConversionService conversionService, MediaTypeCodecRegistry mediaTypeCodecRegistry, MessageBodyHandlerRegistry messageBodyHandlerRegistry) {
        this.httpResponse = httpResponse;
        this.bodyType = bodyType;
        this.conversionService = conversionService;
        this.mediaTypeCodecRegistry = mediaTypeCodecRegistry;
        this.messageBodyHandlerRegistry = messageBodyHandlerRegistry;
    }

    public HttpStatus getStatus() {
        return HttpStatus.valueOf((int)this.httpResponse.statusCode());
    }

    public int code() {
        return this.httpResponse.statusCode();
    }

    public String reason() {
        return this.getStatus().getReason();
    }

    public HttpHeaders getHeaders() {
        return new HttpHeadersAdapter(this.httpResponse.headers(), this.conversionService);
    }

    public MutableConvertibleValues<Object> getAttributes() {
        return this.attributes;
    }

    public Optional<O> getBody() {
        return this.getBody(this.bodyType);
    }

    public <T> Optional<T> getBody(Argument<T> type) {
        boolean isOptional = type.getType() == Optional.class;
        Argument<T> theArgument = isOptional ? type.getFirstTypeVariable().orElse(type) : type;
        Optional<T> optional = this.convertBytes(this.getContentType().orElse(null), this.httpResponse.body(), theArgument);
        if (isOptional) {
            return Optional.of(optional);
        }
        return optional;
    }

    private <T> Optional<T> convertBytes(@Nullable MediaType contentType, byte[] bytes, Argument<T> type) {
        MessageBodyReader reader;
        Optional foundCodec;
        if (bytes.length == 0) {
            return Optional.empty();
        }
        if (type.getType().equals(byte[].class)) {
            return Optional.of(bytes);
        }
        if (contentType != null && CharSequence.class.isAssignableFrom(type.getType())) {
            Charset charset = contentType.getCharset().orElse(StandardCharsets.UTF_8);
            return Optional.of(new String(bytes, charset));
        }
        if (this.mediaTypeCodecRegistry != null && (foundCodec = this.mediaTypeCodecRegistry.findCodec(contentType)).isPresent()) {
            try {
                return foundCodec.map(codec -> codec.decode(type, bytes));
            }
            catch (CodecException e) {
                this.logCodecError(contentType, type, e);
            }
        }
        if (this.messageBodyHandlerRegistry != null && (reader = (MessageBodyReader)this.messageBodyHandlerRegistry.findReader(type, contentType).orElse(null)) != null) {
            try {
                Object value = reader.read(type, contentType, (Headers)this.getHeaders(), (ByteBuffer)ByteArrayBufferFactory.INSTANCE.wrap(bytes));
                return Optional.of(value);
            }
            catch (CodecException e) {
                this.logCodecError(contentType, type, e);
            }
        }
        return this.conversionService.convert((Object)bytes, ConversionContext.of(type));
    }

    private <T> void logCodecError(MediaType contentType, Argument<T> type, CodecException e) {
        if (LOG.isDebugEnabled()) {
            String message = e.getMessage();
            LOG.debug("Error decoding body for type [{}] from '{}'. Attempting fallback.", type, (Object)contentType);
            LOG.debug("CodecException Message was: {}", (Object)(message == null ? "null" : message.replace("\n", "")));
        }
    }
}

