/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.jdk.cookie;

import io.micronaut.context.annotation.Primary;
import io.micronaut.core.annotation.Internal;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.client.jdk.cookie.CookieDecoder;
import io.micronaut.http.cookie.Cookies;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Optional;

@Primary
@Singleton
@Internal
public class CompositeCookieDecoder
implements CookieDecoder {
    private final List<CookieDecoder> cookieDecoders;

    @Inject
    public CompositeCookieDecoder(List<CookieDecoder> cookieDecoders) {
        this.cookieDecoders = cookieDecoders;
    }

    @Override
    public Optional<Cookies> decode(HttpRequest<?> request) {
        return this.cookieDecoders.stream().map(d -> d.decode(request)).filter(Optional::isPresent).findFirst().orElseGet(Optional::empty);
    }
}

