/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.HttpClientFactory;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Internal
public abstract class AbstractHttpClientFactory<T extends HttpClient>
implements HttpClientFactory {
    protected final MediaTypeCodecRegistry mediaTypeCodecRegistry;
    protected final MessageBodyHandlerRegistry messageBodyHandlerRegistry;
    protected final ConversionService conversionService;

    protected AbstractHttpClientFactory(@Nullable MediaTypeCodecRegistry mediaTypeCodecRegistry, MessageBodyHandlerRegistry messageBodyHandlerRegistry, ConversionService conversionService) {
        this.mediaTypeCodecRegistry = mediaTypeCodecRegistry;
        this.messageBodyHandlerRegistry = messageBodyHandlerRegistry;
        this.conversionService = conversionService;
    }

    protected abstract @NonNull T createHttpClient(@Nullable URI var1);

    protected abstract @NonNull T createHttpClient(@Nullable URI var1, @NonNull HttpClientConfiguration var2);

    @Override
    public @NonNull HttpClient createClient(URL url) {
        return this.createHttpClient(url);
    }

    @Override
    public @NonNull HttpClient createClient(URL url, @NonNull HttpClientConfiguration configuration) {
        return this.createHttpClient(url, configuration);
    }

    private T createHttpClient(URL url) {
        try {
            return this.createHttpClient(url != null ? url.toURI() : null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private @NonNull T createHttpClient(@Nullable URL url, @NonNull HttpClientConfiguration configuration) {
        try {
            return this.createHttpClient(url != null ? url.toURI() : null, configuration);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

