/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.exceptions;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.Described;
import io.micronaut.core.type.Argument;
import io.micronaut.http.MediaType;
import io.micronaut.http.hateoas.JsonError;
import io.micronaut.http.hateoas.VndError;
import java.util.Optional;

@Internal
public interface HttpClientErrorDecoder {
    public static final HttpClientErrorDecoder DEFAULT = new HttpClientErrorDecoder(){};

    default public Optional<String> getMessage(Object error) {
        if (error == null) {
            return Optional.empty();
        }
        if (error instanceof JsonError) {
            JsonError jsonError = (JsonError)error;
            return Optional.ofNullable(jsonError.getMessage());
        }
        if (error instanceof Described) {
            Described described = (Described)error;
            return Optional.ofNullable(described.getDescription());
        }
        return Optional.of(error.toString());
    }

    default public Argument<?> getErrorType(MediaType mediaType) {
        if (mediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
            return Argument.of(JsonError.class);
        }
        if (mediaType.equals((Object)MediaType.APPLICATION_VND_ERROR_TYPE)) {
            return Argument.of(VndError.class);
        }
        return Argument.STRING;
    }
}

