/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client;

import java.util.Objects;

public final class ProxyRequestOptions {
    private static final ProxyRequestOptions DEFAULT = ProxyRequestOptions.builder().build();
    private final boolean retainHostHeader;

    private ProxyRequestOptions(Builder builder) {
        this.retainHostHeader = builder.retainHostHeader;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ProxyRequestOptions getDefault() {
        return DEFAULT;
    }

    public boolean isRetainHostHeader() {
        return this.retainHostHeader;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof ProxyRequestOptions)) return false;
        ProxyRequestOptions pro = (ProxyRequestOptions)o;
        if (this.isRetainHostHeader() != pro.isRetainHostHeader()) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hashCode(this.isRetainHostHeader());
    }

    public static final class Builder {
        private boolean retainHostHeader = false;

        private Builder() {
        }

        public ProxyRequestOptions build() {
            return new ProxyRequestOptions(this);
        }

        public Builder retainHostHeader(boolean retainHostHeader) {
            this.retainHostHeader = retainHostHeader;
            return this;
        }

        public Builder retainHostHeader() {
            return this.retainHostHeader(true);
        }
    }
}

